/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.mongodb.configuration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.loaders.mongodb.configuration.MongoDBCacheStoreConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.mongodb.configuration.XmlFileParsingTest")
public class XmlFileParsingTest
extends AbstractInfinispanTest {
    private EmbeddedCacheManager cacheManager;

    @AfterMethod(alwaysRun=true)
    public void cleanup() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    public void testRemoteCacheStore() throws Exception {
        String config = "<infinispan>\n   <default>\n     <loaders>\n       <mongodbStore xmlns=\"urn:infinispan:config:mongodb:5.3\" >\n         <connection host=\"localhost\" port=\"27017\" timeout=\"2000\" acknowledgment=\"0\"/>\n\t\t  <authentication username=\"mongoUser\" password=\"mongoPass\" />\n\t\t  <storage database=\"infinispan_test_database\" collection=\"infispan_cachestore\" />\n       </mongodbStore>\n     </loaders>\n   </default>\n</infinispan>";
        MongoDBCacheStoreConfiguration store = (MongoDBCacheStoreConfiguration)this.buildCacheManagerWithCacheStore(config);
        assert (store.host().equals("localhost"));
        assert (store.port() == 27017);
        assert (store.username().equals("mongoUser"));
        assert (store.password().equals("mongoPass"));
        assert (store.database().equals("infinispan_test_database"));
        assert (store.collection().equals("infispan_cachestore"));
        assert (store.acknowledgment() == 0);
        assert (store.fetchPersistentState());
        assert (store.purgeOnStartup());
        assert (store.ignoreModifications());
        assert (store.async().enabled());
    }

    private CacheLoaderConfiguration buildCacheManagerWithCacheStore(String config) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.cacheManager = TestCacheManagerFactory.fromStream((InputStream)is);
        assert (this.cacheManager.getDefaultCacheConfiguration().loaders().cacheLoaders().size() == 1);
        return (CacheLoaderConfiguration)this.cacheManager.getDefaultCacheConfiguration().loaders().cacheLoaders().get(0);
    }
}

