/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.mongodb.cache;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.infinispan.persistence.mongodb.cache.MongoDBCache;
import org.infinispan.persistence.mongodb.configuration.MongoDBStoreConfiguration;
import org.infinispan.persistence.mongodb.store.MongoDBEntry;
import org.infinispan.util.TimeService;

public class MongoDBCacheImpl<K, V>
implements MongoDBCache<K, V> {
    private static final int pagingSize = 1024;
    private final TimeService timeService;
    private MongoClient mongoClient;
    private MongoCollection<Document> collection;
    private MongoDBStoreConfiguration mongoCacheConfiguration;

    public MongoDBCacheImpl(MongoDBStoreConfiguration mongoCacheConfiguration, TimeService timeService) throws Exception {
        this.mongoCacheConfiguration = mongoCacheConfiguration;
        this.timeService = timeService;
        this.init();
    }

    private void init() throws Exception {
        this.start();
    }

    @Override
    public void start() throws Exception {
        MongoClientURI mongoClientURI = new MongoClientURI(this.mongoCacheConfiguration.getConnectionURI());
        this.mongoClient = new MongoClient(mongoClientURI);
        MongoDatabase database = this.mongoClient.getDatabase(mongoClientURI.getDatabase());
        this.collection = database.getCollection(this.mongoCacheConfiguration.collection());
    }

    @Override
    public int size() {
        return (int)this.collection.count();
    }

    @Override
    public void clear() {
        this.collection.drop();
    }

    @Override
    public boolean remove(byte[] key) {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)key);
        return this.collection.findOneAndDelete((Bson)query) != null;
    }

    @Override
    public MongoDBEntry<K, V> get(byte[] key) {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)key);
        MongoCursor iterator = this.collection.find((Bson)query).iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return this.createEntry((Document)iterator.next());
    }

    private MongoDBEntry<K, V> createEntry(Document document) {
        byte[] k = ((Binary)document.get((Object)"_id")).getData();
        byte[] v = ((Binary)document.get((Object)"value")).getData();
        byte[] m = ((Binary)document.get((Object)"metadata")).getData();
        MongoDBEntry.Builder mongoDBEntryBuilder = MongoDBEntry.builder();
        mongoDBEntryBuilder.keyBytes(k).valueBytes(v).metadataBytes(m);
        return mongoDBEntryBuilder.create();
    }

    @Override
    public boolean containsKey(byte[] key) {
        return this.get(key) != null;
    }

    @Override
    public List<MongoDBEntry<K, V>> getPagedEntries(byte[] lastKey) {
        FindIterable iterable = lastKey != null ? this.collection.find(Filters.lt((String)"_id", (Object)lastKey)) : this.collection.find();
        iterable.sort(Sorts.descending((String[])new String[]{"_id"})).limit(1024);
        ArrayList<MongoDBEntry<K, V>> entries = new ArrayList<MongoDBEntry<K, V>>();
        iterable.map(this::createEntry).into(entries);
        return entries;
    }

    @Override
    public List<MongoDBEntry<K, V>> removeExpiredData(byte[] lastKey) {
        long time = this.timeService.wallClockTime();
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.lte((String)"expiryTime", (Object)new Date(time)), Filters.gt((String)"expiryTime", (Object)new Date(-1L))});
        if (lastKey != null) {
            filter = Filters.and((Bson[])new Bson[]{filter, Filters.lt((String)"_id", (Object)lastKey)});
        }
        FindIterable iterable = this.collection.find(filter).sort(Sorts.descending((String[])new String[]{"_id"})).limit(1024);
        ArrayList<MongoDBEntry<K, V>> listOfExpiredEntries = new ArrayList<MongoDBEntry<K, V>>();
        iterable.map(this::createEntry).into(listOfExpiredEntries);
        this.collection.deleteMany(filter);
        return listOfExpiredEntries;
    }

    @Override
    public void put(MongoDBEntry<K, V> entry) {
        Document document = new Document("_id", (Object)entry.getKeyBytes()).append("value", (Object)entry.getValueBytes()).append("metadata", (Object)entry.getMetadataBytes()).append("expiryTime", (Object)entry.getExpiryTime());
        if (this.containsKey(entry.getKeyBytes())) {
            this.collection.replaceOne(Filters.eq((String)"_id", (Object)entry.getKeyBytes()), (Object)document);
        } else {
            this.collection.insertOne((Object)document);
        }
    }

    @Override
    public void stop() {
        this.mongoClient.close();
    }
}

