/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.mongodb.configuration.parser;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    CONNECTION_URI("uri"),
    COLLECTION("collection");

    private static final Map<String, Attribute> attributes;
    private final String name;

    private Attribute(String name) {
        this.name = name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    public String getName() {
        return this.name;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

