/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.mongodb.store;

import java.util.Date;
import org.infinispan.commons.marshall.Marshaller;

public class MongoDBEntry<K, V> {
    private K key;
    private V value;
    private byte[] keyBytes;
    private byte[] valueBytes;
    private byte[] metadataBytes;
    private Date expiryTime;

    public MongoDBEntry(byte[] keyBytes, byte[] valueBytes, byte[] metadataBytes, Date expiryTime) {
        this.keyBytes = keyBytes;
        this.valueBytes = valueBytes;
        this.metadataBytes = metadataBytes;
        this.expiryTime = expiryTime;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public void setKeyBytes(byte[] keyBytes) {
        this.keyBytes = keyBytes;
    }

    public byte[] getValueBytes() {
        return this.valueBytes;
    }

    public void setValueBytes(byte[] valueBytes) {
        this.valueBytes = valueBytes;
    }

    public byte[] getMetadataBytes() {
        return this.metadataBytes;
    }

    public void setMetadataBytes(byte[] metadataBytes) {
        this.metadataBytes = metadataBytes;
    }

    public Date getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(Date expiryTime) {
        this.expiryTime = expiryTime;
    }

    public K getKey(Marshaller marshaller) {
        try {
            return (K)marshaller.objectFromByteBuffer(this.keyBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public V getValue(Marshaller marshaller) {
        try {
            return (V)marshaller.objectFromByteBuffer(this.valueBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class Builder<K, V> {
        private byte[] keyBytes;
        private byte[] valueBytes;
        private byte[] metadataBytes;
        private Date expiryTime;

        private Builder() {
        }

        public Builder<K, V> keyBytes(byte[] keyBytes) {
            this.keyBytes = keyBytes;
            return this;
        }

        public Builder<K, V> valueBytes(byte[] valueBytes) {
            this.valueBytes = valueBytes;
            return this;
        }

        public Builder<K, V> metadataBytes(byte[] metadataBytes) {
            this.metadataBytes = metadataBytes;
            return this;
        }

        public Builder<K, V> expiryTime(Date expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public MongoDBEntry<K, V> create() {
            return new MongoDBEntry(this.keyBytes, this.valueBytes, this.metadataBytes, this.expiryTime);
        }
    }
}

