/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.mongodb.store;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executor;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.executors.ExecutorAllCompletionService;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.mongodb.cache.MongoDBCache;
import org.infinispan.persistence.mongodb.cache.MongoDBCacheImpl;
import org.infinispan.persistence.mongodb.configuration.MongoDBStoreConfiguration;
import org.infinispan.persistence.mongodb.store.MongoDBEntry;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;

@ThreadSafe
public class MongoDBStore<K, V>
implements AdvancedLoadWriteStore<K, V> {
    private InitializationContext context;
    private MongoDBCache<K, V> cache;
    private MongoDBStoreConfiguration configuration;

    public void init(InitializationContext ctx) {
        this.context = ctx;
        this.configuration = (MongoDBStoreConfiguration)ctx.getConfiguration();
        try {
            this.cache = new MongoDBCacheImpl(this.configuration, ctx.getTimeService());
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void process(KeyFilter<? super K> filter, AdvancedCacheLoader.CacheLoaderTask<K, V> task, Executor executor, boolean fetchValue, boolean fetchMetadata) {
        ExecutorAllCompletionService eacs = new ExecutorAllCompletionService(executor);
        TaskContextImpl taskContext = new TaskContextImpl();
        boolean shouldContinue = true;
        byte[] id = null;
        while (shouldContinue) {
            List<MongoDBEntry<K, V>> entries = this.cache.getPagedEntries(id);
            boolean bl = shouldContinue = !entries.isEmpty();
            if (taskContext.isStopped()) break;
            if (!shouldContinue) continue;
            eacs.submit(() -> {
                for (MongoDBEntry entry : entries) {
                    MarshalledEntry<K, V> marshalledEntry;
                    if (taskContext.isStopped()) break;
                    Object marshalledKey = this.toObject(entry.getKeyBytes());
                    if (filter != null && !filter.accept(marshalledKey) || (marshalledEntry = this.getMarshalledEntry(entry)) == null) continue;
                    task.processEntry(marshalledEntry, (AdvancedCacheLoader.TaskContext)taskContext);
                }
                return null;
            });
            id = entries.get(entries.size() - 1).getKeyBytes();
        }
        eacs.waitUntilAllCompleted();
        if (eacs.isExceptionThrown()) {
            throw new PersistenceException("Execution exception!", (Throwable)eacs.getFirstException());
        }
    }

    public int size() {
        return this.cache.size();
    }

    public void clear() {
        this.cache.clear();
    }

    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener listener) {
        byte[] lastKey = null;
        boolean shouldContinue = true;
        while (shouldContinue) {
            List<MongoDBEntry<K, V>> expired = this.cache.removeExpiredData(lastKey);
            expired.forEach(kvMongoDBEntry -> listener.entryPurged(kvMongoDBEntry.getKey((Marshaller)this.marshaller())));
            shouldContinue = !expired.isEmpty();
            if (!shouldContinue) continue;
            lastKey = expired.get(expired.size() - 1).getKeyBytes();
        }
    }

    public void write(MarshalledEntry<? extends K, ? extends V> entry) {
        MongoDBEntry.Builder mongoDBEntryBuilder = MongoDBEntry.builder();
        mongoDBEntryBuilder.keyBytes(this.toByteArray(entry.getKey())).valueBytes(this.toByteArray(entry.getValue())).metadataBytes(this.toByteArray(entry.getMetadata())).expiryTime(entry.getMetadata() != null ? new Date(entry.getMetadata().expiryTime()) : null);
        MongoDBEntry mongoDBEntry = mongoDBEntryBuilder.create();
        this.cache.put(mongoDBEntry);
    }

    public boolean delete(Object key) {
        return this.cache.remove(this.toByteArray(key));
    }

    public MarshalledEntry<K, V> load(Object key) {
        return this.load(key, false);
    }

    private MarshalledEntry<K, V> load(Object key, boolean binaryData) {
        MongoDBEntry<K, V> mongoDBEntry = this.cache.get(this.toByteArray(key));
        if (mongoDBEntry == null) {
            return null;
        }
        K k = mongoDBEntry.getKey((Marshaller)this.marshaller());
        V v = mongoDBEntry.getValue((Marshaller)this.marshaller());
        InternalMetadata metadata = (InternalMetadata)this.toObject(mongoDBEntry.getMetadataBytes());
        MarshalledEntry result = this.context.getMarshalledEntryFactory().newMarshalledEntry(k, v, metadata);
        if (this.isExpired(result)) {
            return null;
        }
        return result;
    }

    private MarshalledEntry<K, V> getMarshalledEntry(MongoDBEntry<K, V> mongoDBEntry) {
        if (mongoDBEntry == null) {
            return null;
        }
        K k = mongoDBEntry.getKey((Marshaller)this.marshaller());
        V v = mongoDBEntry.getValue((Marshaller)this.marshaller());
        InternalMetadata metadata = (InternalMetadata)this.toObject(mongoDBEntry.getMetadataBytes());
        MarshalledEntry result = this.context.getMarshalledEntryFactory().newMarshalledEntry(k, v, metadata);
        return result;
    }

    public boolean contains(Object key) {
        MongoDBEntry<K, V> mongoDBEntry = this.cache.get(this.toByteArray(key));
        MarshalledEntry<K, V> result = this.getMarshalledEntry(mongoDBEntry);
        return mongoDBEntry != null && !this.isExpired(result);
    }

    public void start() {
        try {
            this.cache.start();
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
        if (this.configuration.purgeOnStartup()) {
            this.cache.clear();
        }
    }

    public void stop() {
        this.cache.stop();
    }

    private boolean isExpired(MarshalledEntry result) {
        if (result.getMetadata() == null) {
            return false;
        }
        return result.getMetadata().isExpired(this.context.getTimeService().wallClockTime());
    }

    private Object toObject(byte[] bytes) {
        try {
            return this.marshaller().objectFromByteBuffer(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private byte[] toByteArray(Object obj) {
        try {
            return this.marshaller().objectToByteBuffer(obj);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    private StreamingMarshaller marshaller() {
        return this.context.getMarshaller();
    }

    public InitializationContext getContext() {
        return this.context;
    }

    public void setContext(InitializationContext context) {
        this.context = context;
    }

    public MongoDBCache<K, V> getCache() {
        return this.cache;
    }
}

