/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.Properties;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.ExhaustedAction;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.remote.configuration.ConfigurationTest")
public class ConfigurationTest {
    public void testRemoteCacheStoreConfigurationAdaptor() {
        Properties p = new Properties();
        p.setProperty("protocolVersion", "2.7");
        ConfigurationBuilder b = new ConfigurationBuilder();
        ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)b.persistence().addStore(RemoteStoreConfigurationBuilder.class)).remoteCacheName("RemoteCache").fetchPersistentState(true)).addServer().host("one").port(12111).addServer().host("two").connectionPool().maxActive(10).minIdle(5).exhaustedAction(ExhaustedAction.EXCEPTION).minEvictableIdleTime(10000L).async().enable().withProperties(p);
        Configuration configuration = b.build();
        RemoteStoreConfiguration store = (RemoteStoreConfiguration)configuration.persistence().stores().get(0);
        AssertJUnit.assertEquals((String)"RemoteCache", (String)store.remoteCacheName());
        AssertJUnit.assertEquals((int)2, (int)store.servers().size());
        AssertJUnit.assertEquals((int)10, (int)store.connectionPool().maxActive());
        AssertJUnit.assertEquals((int)5, (int)store.connectionPool().minIdle());
        AssertJUnit.assertEquals((Object)ExhaustedAction.EXCEPTION, (Object)store.connectionPool().exhaustedAction());
        AssertJUnit.assertEquals((long)10000L, (long)store.connectionPool().minEvictableIdleTime());
        AssertJUnit.assertTrue((boolean)store.fetchPersistentState());
        AssertJUnit.assertTrue((boolean)store.async().enabled());
        AssertJUnit.assertEquals((Object)ProtocolVersion.PROTOCOL_VERSION_27, (Object)store.protocol());
        b = new ConfigurationBuilder();
        ((RemoteStoreConfigurationBuilder)b.persistence().addStore(RemoteStoreConfigurationBuilder.class)).read(store);
        Configuration configuration2 = b.build();
        RemoteStoreConfiguration store2 = (RemoteStoreConfiguration)configuration2.persistence().stores().get(0);
        AssertJUnit.assertEquals((String)"RemoteCache", (String)store2.remoteCacheName());
        AssertJUnit.assertEquals((int)2, (int)store2.servers().size());
        AssertJUnit.assertEquals((int)10, (int)store2.connectionPool().maxActive());
        AssertJUnit.assertEquals((int)5, (int)store2.connectionPool().minIdle());
        AssertJUnit.assertEquals((Object)ExhaustedAction.EXCEPTION, (Object)store2.connectionPool().exhaustedAction());
        AssertJUnit.assertEquals((long)10000L, (long)store2.connectionPool().minEvictableIdleTime());
        AssertJUnit.assertTrue((boolean)store2.fetchPersistentState());
        AssertJUnit.assertTrue((boolean)store2.async().enabled());
        AssertJUnit.assertEquals((Object)ProtocolVersion.PROTOCOL_VERSION_27, (Object)store2.protocol());
    }
}

