/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.impl.iteration.RemoteCloseableIterator;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.jboss.marshalling.commons.GenericJBossMarshaller;
import org.infinispan.persistence.remote.upgrade.IterationCallBack;

class CallbackRemoteIterator<E>
extends RemoteCloseableIterator<E> {
    private Set<Object> callBackKeys = new HashSet<Object>();
    private IterationCallBack callback;

    CallbackRemoteIterator(OperationsFactory operationsFactory, int batchSize, Set<Integer> segments, boolean metadata, DataFormat dataFormat) {
        super(operationsFactory, (Marshaller)new GenericJBossMarshaller(), batchSize, segments, metadata, dataFormat);
    }

    public void close() {
        super.close();
    }

    public boolean hasNext() {
        return super.hasNext();
    }

    public Map.Entry<Object, E> next() {
        Map.Entry next = super.next();
        Object key = this.unmarshall(next.getKey());
        if (this.callBackKeys.contains(key)) {
            this.callback.iterationReached(key);
        }
        return next;
    }

    private Object unmarshall(Object key) {
        try {
            return this.marshaller.objectFromByteBuffer((byte[])key);
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return key;
        }
    }

    void addCallback(IterationCallBack callback, Object ... keys) {
        Arrays.stream(keys).forEach(this.callBackKeys::add);
        this.callback = callback;
    }
}

