/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote;

import org.infinispan.Cache;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="persistence.remote.RemoteStoreConfigTest", groups={"functional"})
public class RemoteStoreConfigTest
extends AbstractInfinispanTest {
    public static final String CACHE_LOADER_CONFIG = "remote-cl-config.xml";
    public static final String STORE_CACHE_NAME = "RemoteStoreConfigTest";
    private EmbeddedCacheManager cacheManager;
    private HotRodServer hotRodServer;

    @BeforeClass
    public void startUp() {
        this.cacheManager = TestCacheManagerFactory.createCacheManager();
        Cache storeCache = this.cacheManager.createCache(STORE_CACHE_NAME, HotRodTestingUtil.hotRodCacheConfiguration().build());
        AssertJUnit.assertEquals((int)storeCache.size(), (int)0);
        this.hotRodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (int)19711);
    }

    public void simpleTest() throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)CACHE_LOADER_CONFIG)){

            public void call() {
                Cache cache = this.cm.getCache();
                CacheLoader cacheLoader = TestingUtil.getCacheLoader((Cache)cache);
                assert (cacheLoader != null);
                assert (cacheLoader instanceof RemoteStore);
                cache.put((Object)"k", (Object)"v");
                Cache storeCache = RemoteStoreConfigTest.this.cacheManager.getCache(RemoteStoreConfigTest.STORE_CACHE_NAME);
                AssertJUnit.assertEquals((int)1, (int)storeCache.size());
                cache.stop();
                AssertJUnit.assertEquals((int)1, (int)storeCache.size());
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)CACHE_LOADER_CONFIG)){

            public void call() {
                Cache cache = this.cm.getCache(RemoteStoreConfigTest.STORE_CACHE_NAME);
                AssertJUnit.assertEquals((Object)"v", (Object)cache.get((Object)"k"));
            }
        });
    }

    @AfterClass
    public void tearDown() {
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotRodServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }
}

