/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote;

import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.jboss.marshalling.commons.GenericJBossMarshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="persistence.remote.RemoteStoreWrapperTest", groups={"functional"})
public class RemoteStoreWrapperTest
extends AbstractInfinispanTest {
    private final Marshaller marshaller = new GenericJBossMarshaller();
    private HotRodServer sourceServer;
    private HotRodServer targetServer;
    private EmbeddedCacheManager serverCacheManager;
    private Cache<byte[], byte[]> serverCache;
    private EmbeddedCacheManager targetCacheManager;
    private Cache<byte[], byte[]> targetCache;
    private RemoteCacheManager remoteSourceCacheManager;
    private RemoteCache<String, String> remoteSourceCache;
    private RemoteCacheManager remoteTargetCacheManager;
    private RemoteCache<String, String> remoteTargetCache;

    @BeforeClass
    public void setup() throws Exception {
        ConfigurationBuilder serverBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        this.serverCacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)serverBuilder, (MediaType)MediaType.APPLICATION_JBOSS_MARSHALLING));
        this.serverCache = this.serverCacheManager.getCache();
        this.sourceServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.serverCacheManager);
        this.remoteSourceCacheManager = this.createAndStartRemoteCacheManager(this.sourceServer);
        this.remoteSourceCache = this.remoteSourceCacheManager.getCache();
        ConfigurationBuilder clientBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        ((RemoteStoreConfigurationBuilder)clientBuilder.persistence().addStore(RemoteStoreConfigurationBuilder.class)).hotRodWrapping(true).addServer().host(this.sourceServer.getHost()).port(this.sourceServer.getPort().intValue());
        this.targetCacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)clientBuilder, (MediaType)MediaType.APPLICATION_JBOSS_MARSHALLING));
        this.targetCache = this.targetCacheManager.getCache();
        this.targetServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.targetCacheManager);
        this.remoteTargetCacheManager = this.createAndStartRemoteCacheManager(this.targetServer);
        this.remoteTargetCache = this.remoteTargetCacheManager.getCache();
    }

    private RemoteCacheManager createAndStartRemoteCacheManager(HotRodServer server) {
        RemoteCacheManager rcm = new RemoteCacheManager(HotRodClientTestingUtil.newRemoteConfigurationBuilder((HotRodServer)server).marshaller(this.marshaller).build());
        rcm.start();
        return rcm;
    }

    public void testEntryWrapping() throws Exception {
        this.remoteSourceCache.put((Object)"k1", (Object)"v1");
        this.remoteSourceCache.put((Object)"k2", (Object)"v2");
        HotRodTestingUtil.assertHotRodEquals((EmbeddedCacheManager)this.serverCacheManager, (byte[])this.marshall("k1"), (byte[])this.marshall("v1"));
        HotRodTestingUtil.assertHotRodEquals((EmbeddedCacheManager)this.serverCacheManager, (byte[])this.marshall("k2"), (byte[])this.marshall("v2"));
        String v1 = (String)this.remoteTargetCache.get((Object)"k1");
        AssertJUnit.assertEquals((String)"v1", (String)v1);
        String v2 = (String)this.remoteTargetCache.get((Object)"k2");
        AssertJUnit.assertEquals((String)"v2", (String)v2);
    }

    private byte[] marshall(Object o) throws Exception {
        return this.marshaller.objectToByteBuffer(o);
    }

    @BeforeMethod
    public void cleanup() {
        this.serverCache.clear();
        this.targetCache.clear();
    }

    @AfterClass
    public void tearDown() {
        HotRodClientTestingUtil.killRemoteCacheManagers((RemoteCacheManager[])new RemoteCacheManager[]{this.remoteSourceCacheManager, this.remoteTargetCacheManager});
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.sourceServer, this.targetServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.targetCacheManager, this.serverCacheManager});
    }
}

