/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.jboss.marshalling.commons.GenericJBossMarshaller;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.upgrade.IterationCallBack;
import org.infinispan.persistence.remote.upgrade.TestCluster;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="upgrade.hotrod.HotRodUpgradeSynchronizerTest", groups={"functional"})
public class HotRodUpgradeSynchronizerTest
extends AbstractInfinispanTest {
    protected TestCluster sourceCluster;
    protected TestCluster targetCluster;
    protected static final String OLD_CACHE = "old-cache";
    protected static final String TEST_CACHE = HotRodUpgradeSynchronizerTest.class.getName();
    protected static final ProtocolVersion OLD_PROTOCOL_VERSION = ProtocolVersion.PROTOCOL_VERSION_20;
    protected static final ProtocolVersion NEW_PROTOCOL_VERSION = ProtocolVersion.DEFAULT_PROTOCOL_VERSION;

    @BeforeMethod
    public void setup() throws Exception {
        this.sourceCluster = new TestCluster.Builder().setName("sourceCluster").setNumMembers(1).cache().name(OLD_CACHE).cache().name(TEST_CACHE).build();
        this.targetCluster = new TestCluster.Builder().setName("targetCluster").setNumMembers(1).cache().name(OLD_CACHE).remotePort(this.sourceCluster.getHotRodPort()).remoteProtocolVersion(OLD_PROTOCOL_VERSION).cache().name(TEST_CACHE).remotePort(this.sourceCluster.getHotRodPort()).remoteProtocolVersion(NEW_PROTOCOL_VERSION).build();
    }

    private void fillCluster(TestCluster cluster, String cacheName) {
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            String s = Character.toString(ch);
            cluster.getRemoteCache(cacheName).put((Object)s, (Object)s, 20L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS);
        }
    }

    public void testSynchronization() throws Exception {
        RemoteCache<String, String> sourceRemoteCache = this.sourceCluster.getRemoteCache(TEST_CACHE);
        RemoteCache<String, String> targetRemoteCache = this.targetCluster.getRemoteCache(TEST_CACHE);
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            String s = Character.toString(ch);
            sourceRemoteCache.put((Object)s, (Object)s, 20L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS);
        }
        AssertJUnit.assertEquals((String)"A", (String)((String)targetRemoteCache.get((Object)"A")));
        RollingUpgradeManager upgradeManager = this.targetCluster.getRollingUpgradeManager(TEST_CACHE);
        long count = upgradeManager.synchronizeData("hotrod");
        AssertJUnit.assertEquals((long)26L, (long)count);
        AssertJUnit.assertEquals((int)this.sourceCluster.getEmbeddedCache(TEST_CACHE).size(), (int)this.targetCluster.getEmbeddedCache(TEST_CACHE).size());
        upgradeManager.disconnectSource("hotrod");
        MetadataValue metadataValue = targetRemoteCache.getWithMetadata((Object)"Z");
        AssertJUnit.assertEquals((int)20, (int)metadataValue.getLifespan());
        AssertJUnit.assertEquals((int)30, (int)metadataValue.getMaxIdle());
    }

    public void testSynchronizationWithClientChanges() throws Exception {
        this.fillCluster(this.sourceCluster, TEST_CACHE);
        RemoteCache<String, String> remoteCache = this.targetCluster.getRemoteCache(TEST_CACHE);
        remoteCache.remove((Object)"G");
        remoteCache.put((Object)"U", (Object)"I");
        remoteCache.put((Object)"a", (Object)"a");
        AssertJUnit.assertFalse((boolean)remoteCache.containsKey((Object)"G"));
        AssertJUnit.assertEquals((String)"a", (String)((String)remoteCache.get((Object)"a")));
        AssertJUnit.assertEquals((String)"I", (String)((String)remoteCache.get((Object)"U")));
        RollingUpgradeManager rum = this.targetCluster.getRollingUpgradeManager(TEST_CACHE);
        rum.synchronizeData("hotrod");
        rum.disconnectSource("hotrod");
        AssertJUnit.assertFalse((boolean)remoteCache.containsKey((Object)"G"));
        AssertJUnit.assertEquals((String)"a", (String)((String)remoteCache.get((Object)"a")));
        AssertJUnit.assertEquals((String)"I", (String)((String)remoteCache.get((Object)"U")));
    }

    @Test
    public void testSynchronizationWithInFlightUpdates() throws Exception {
        this.fillCluster(this.sourceCluster, TEST_CACHE);
        RemoteCache<String, String> remoteCache = this.targetCluster.getRemoteCache(TEST_CACHE);
        this.doWhenSourceIterationReaches("M", this.targetCluster, TEST_CACHE, key -> remoteCache.put((Object)"M", (Object)"changed"));
        RollingUpgradeManager rum = this.targetCluster.getRollingUpgradeManager(TEST_CACHE);
        rum.synchronizeData("hotrod");
        rum.disconnectSource("hotrod");
        AssertJUnit.assertEquals((String)"changed", (String)((String)remoteCache.get((Object)"M")));
    }

    @Test
    public void testSynchronizationWithInFlightDeletes() throws Exception {
        this.fillCluster(this.sourceCluster, TEST_CACHE);
        RemoteCache<String, String> remoteCache = this.targetCluster.getRemoteCache(TEST_CACHE);
        this.doWhenSourceIterationReaches("L", this.targetCluster, TEST_CACHE, key -> remoteCache.remove((Object)"L"));
        RollingUpgradeManager rum = this.targetCluster.getRollingUpgradeManager(TEST_CACHE);
        rum.synchronizeData("hotrod");
        rum.disconnectSource("hotrod");
        AssertJUnit.assertNull((Object)remoteCache.get((Object)"L"));
    }

    private void doWhenSourceIterationReaches(String key, TestCluster cluster, String cacheName, IterationCallBack callback) {
        cluster.getEmbeddedCaches(cacheName).forEach(c -> {
            PersistenceManager pm = (PersistenceManager)TestingUtil.extractComponent((Cache)c, PersistenceManager.class);
            RemoteStore remoteStore = (RemoteStore)pm.getStores(RemoteStore.class).iterator().next();
            RemoteCacheImpl remoteCache = (RemoteCacheImpl)TestingUtil.extractField((Object)remoteStore, (String)"remoteCache");
            RemoteCacheImpl spy = (RemoteCacheImpl)Mockito.spy((Object)remoteCache);
            ((RemoteCacheImpl)Mockito.doAnswer(invocation -> {
                Object[] params = invocation.getArguments();
                CloseableIterator iterator = remoteCache.retrieveEntriesWithMetadata(null, ((Integer)params[1]).intValue());
                GenericJBossMarshaller marshaller = new GenericJBossMarshaller();
                return new IteratorMapper((Iterator)iterator, arg_0 -> HotRodUpgradeSynchronizerTest.lambda$doWhenSourceIterationReaches$2(key, (Marshaller)marshaller, callback, arg_0));
            }).when((Object)spy)).retrieveEntriesWithMetadata((Set)ArgumentMatchers.isNull(), Matchers.anyInt());
            TestingUtil.replaceField((Object)spy, (String)"remoteCache", (Object)remoteStore, RemoteStore.class);
        });
    }

    @AfterMethod
    public void tearDown() {
        this.sourceCluster.destroy();
        this.targetCluster.destroy();
    }

    private static /* synthetic */ Map.Entry lambda$doWhenSourceIterationReaches$2(String key, Marshaller marshaller, IterationCallBack callback, Map.Entry entry) {
        try {
            if (key.equals(marshaller.objectFromByteBuffer((byte[])entry.getKey()))) {
                callback.iterationReached(key);
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        return entry;
    }
}

