/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.infinispan.CacheException;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.remote.RemoteCacheStore;
import org.infinispan.util.FileLookup;
import org.infinispan.util.Util;

public class RemoteCacheStoreConfig
extends AbstractCacheStoreConfig {
    private volatile String remoteCacheName;
    private final Properties hotRodClientProperties = new Properties();

    public RemoteCacheStoreConfig() {
        this.setCacheLoaderClassName(RemoteCacheStore.class.getName());
    }

    public void setRemoteCacheName(String remoteCacheName) {
        this.remoteCacheName = remoteCacheName;
    }

    public String getRemoteCacheName() {
        return this.remoteCacheName;
    }

    public void setUseDefaultRemoteCache(boolean useDefaultRemoteCache) {
        if (useDefaultRemoteCache) {
            this.setRemoteCacheName("___defaultcache");
        }
    }

    public boolean isUseDefaultRemoteCache() {
        return "___defaultcache".equals(this.getRemoteCacheName());
    }

    public Properties getHotRodClientProperties() {
        return this.hotRodClientProperties;
    }

    public void setHotRodClientProperties(Properties props) {
        this.hotRodClientProperties.putAll((Map<?, ?>)props);
    }

    public void setHotRodClientPropertiesFile(String hotRodClientProperties) {
        FileLookup fileLookup = new FileLookup();
        InputStream inputStream = fileLookup.lookupFile(hotRodClientProperties);
        try {
            this.hotRodClientProperties.load(inputStream);
        }
        catch (IOException e) {
            this.log.error((Object)"Issues while loading properties from file", (Throwable)e);
            throw new CacheException((Throwable)e);
        }
        finally {
            Util.close((Closeable)inputStream);
        }
    }
}

