/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.remote;

import java.io.IOException;
import junit.framework.Assert;
import org.infinispan.Cache;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.remote.RemoteCacheStore;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(testName="loaders.remote.RemoteCacheStoreConfigTest", groups={"functional"})
public class RemoteCacheStoreConfigTest {
    public static final String CACHE_LOADER_CONFIG = "remote-cl-config.xml";
    private EmbeddedCacheManager cacheManager;
    private HotRodServer hotRodServer;

    @BeforeTest
    public void startUp() {
        this.cacheManager = TestCacheManagerFactory.createLocalCacheManager();
        Assert.assertEquals((int)this.cacheManager.getCache().size(), (int)0);
        this.hotRodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (int)19711);
    }

    public void simpleTest() throws IOException {
        DefaultCacheManager cm = new DefaultCacheManager(CACHE_LOADER_CONFIG);
        Cache cache = cm.getCache();
        CacheLoader cacheLoader = TestingUtil.getCacheLoader((Cache)cache);
        assert (cacheLoader != null);
        assert (cacheLoader instanceof RemoteCacheStore);
        cache.put((Object)"k", (Object)"v");
        Assert.assertEquals((int)1, (int)this.cacheManager.getCache().size());
        cache.stop();
        Assert.assertEquals((int)1, (int)this.cacheManager.getCache().size());
        cm.stop();
        cm = new DefaultCacheManager(CACHE_LOADER_CONFIG);
        cache = cm.getCache();
        Assert.assertEquals((Object)"v", (Object)cache.get((Object)"k"));
    }

    @AfterTest
    public void tearDown() {
        this.hotRodServer.stop();
        this.cacheManager.stop();
    }
}

