/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="persistence.remote.RemoteStoreMixedAccessTest", groups={"functional"})
public class RemoteStoreMixedAccessTest
extends AbstractInfinispanTest {
    private HotRodServer hrServer;
    private EmbeddedCacheManager serverCacheManager;
    private Cache<String, String> serverCache;
    private EmbeddedCacheManager clientCacheManager;
    private Cache<String, String> clientCache;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<String, String> remoteCache;

    @BeforeClass
    public void setup() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder serverBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        serverBuilder.eviction().maxEntries(100).strategy(EvictionStrategy.UNORDERED).expiration().wakeUpInterval(10L);
        this.serverCacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)serverBuilder));
        this.serverCache = this.serverCacheManager.getCache();
        this.hrServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.serverCacheManager);
        org.infinispan.configuration.cache.ConfigurationBuilder clientBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        ((RemoteStoreConfigurationBuilder)clientBuilder.persistence().addStore(RemoteStoreConfigurationBuilder.class)).rawValues(true).addServer().host(this.hrServer.getHost()).port(this.hrServer.getPort());
        this.clientCacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)clientBuilder);
        this.clientCache = this.clientCacheManager.getCache();
        ConfigurationBuilder rcmBuilder = new ConfigurationBuilder();
        rcmBuilder.addServer().host(this.hrServer.getHost()).port(this.hrServer.getPort());
        this.remoteCacheManager = new RemoteCacheManager(rcmBuilder.build());
        this.remoteCacheManager.start();
        this.remoteCache = this.remoteCacheManager.getCache();
    }

    public void testMixedAccess() {
        this.remoteCache.put((Object)"k1", (Object)"v1");
        String rv1 = (String)this.remoteCache.get((Object)"k1");
        AssertJUnit.assertEquals((String)"v1", (String)rv1);
        MetadataValue mv1 = this.remoteCache.getWithMetadata((Object)"k1");
        AssertJUnit.assertEquals((String)"v1", (String)((String)mv1.getValue()));
        String cv1 = (String)this.clientCache.get((Object)"k1");
        AssertJUnit.assertEquals((String)"v1", (String)cv1);
    }

    public void testMixedAccessWithLifespan() {
        this.remoteCache.put((Object)"k1", (Object)"v1", 120L, TimeUnit.SECONDS);
        MetadataValue mv1 = this.remoteCache.getWithMetadata((Object)"k1");
        AssertJUnit.assertEquals((String)"v1", (String)((String)mv1.getValue()));
        AssertJUnit.assertEquals((int)120, (int)mv1.getLifespan());
        String cv1 = (String)this.clientCache.get((Object)"k1");
        AssertJUnit.assertEquals((String)"v1", (String)cv1);
        InternalCacheEntry ice1 = this.clientCache.getAdvancedCache().getDataContainer().get((Object)"k1");
        AssertJUnit.assertEquals((long)120000L, (long)ice1.getLifespan());
    }

    public void testMixedAccessWithLifespanAndMaxIdle() {
        this.remoteCache.put((Object)"k1", (Object)"v1", 120L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS);
        MetadataValue mv1 = this.remoteCache.getWithMetadata((Object)"k1");
        AssertJUnit.assertEquals((String)"v1", (String)((String)mv1.getValue()));
        AssertJUnit.assertEquals((int)120, (int)mv1.getLifespan());
        AssertJUnit.assertEquals((int)30, (int)mv1.getMaxIdle());
        String cv1 = (String)this.clientCache.get((Object)"k1");
        AssertJUnit.assertEquals((String)"v1", (String)cv1);
        InternalCacheEntry ice1 = this.clientCache.getAdvancedCache().getDataContainer().get((Object)"k1");
        AssertJUnit.assertEquals((long)120000L, (long)ice1.getLifespan());
        AssertJUnit.assertEquals((long)30000L, (long)ice1.getMaxIdle());
    }

    @BeforeMethod
    public void cleanup() {
        this.serverCache.clear();
        this.clientCache.clear();
    }

    @AfterClass
    public void tearDown() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheManager)this.remoteCacheManager);
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hrServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.clientCacheManager, this.serverCacheManager});
    }
}

