/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.upgrade.RollingUpgradeManager;

public class Cluster {
    private List<HotRodServer> hotRodServers;
    private List<EmbeddedCacheManager> embeddedCacheManagers;
    private RemoteCacheManager remoteCacheManager;

    private Cluster(List<HotRodServer> hotRodServers, List<EmbeddedCacheManager> embeddedCacheManagers, RemoteCacheManager remoteCacheManager) {
        this.hotRodServers = hotRodServers;
        this.embeddedCacheManagers = embeddedCacheManagers;
        this.remoteCacheManager = remoteCacheManager;
    }

    RemoteCache<String, String> getRemoteCache(String cacheName) {
        return this.remoteCacheManager.getCache(cacheName);
    }

    void destroy() {
        this.embeddedCacheManagers.forEach(xva$0 -> TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{xva$0}));
        this.hotRodServers.forEach(xva$0 -> HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{xva$0}));
        HotRodClientTestingUtil.killRemoteCacheManagers((RemoteCacheManager[])new RemoteCacheManager[]{this.remoteCacheManager});
    }

    Cache<String, String> getEmbeddedCache(String name) {
        return this.embeddedCacheManagers.get(0).getCache(name);
    }

    RollingUpgradeManager getRollingUpgradeManager(String cacheName) {
        return (RollingUpgradeManager)this.embeddedCacheManagers.get(0).getCache(cacheName).getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
    }

    int getHotRodPort() {
        return this.hotRodServers.get(0).getAddress().port();
    }

    void cleanAllCaches() {
        this.embeddedCacheManagers.stream().flatMap(m -> m.getCacheNames().stream().map(arg_0 -> ((EmbeddedCacheManager)m).getCache(arg_0))).forEach(Cache::clear);
    }

    static class Builder {
        private String name = "cluster1";
        private int numMembers = 1;
        private Map<String, org.infinispan.configuration.cache.ConfigurationBuilder> caches = new HashMap<String, org.infinispan.configuration.cache.ConfigurationBuilder>();

        Builder() {
        }

        Builder setNumMembers(int numMembers) {
            this.numMembers = numMembers;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        CacheDefinitionBuilder cache() {
            return new CacheDefinitionBuilder(this);
        }

        private void addCache(String name, org.infinispan.configuration.cache.ConfigurationBuilder cfg) {
            this.caches.put(name, cfg);
        }

        public Cluster build() {
            ArrayList<HotRodServer> hotRodServers = new ArrayList<HotRodServer>();
            ArrayList<EmbeddedCacheManager> embeddedCacheManagers = new ArrayList<EmbeddedCacheManager>();
            for (int i = 0; i < this.numMembers; ++i) {
                GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
                gcb.transport().defaultTransport().clusterName(this.name);
                EmbeddedCacheManager clusteredCacheManager = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)gcb, (org.infinispan.configuration.cache.ConfigurationBuilder)AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC));
                this.caches.entrySet().forEach(entry -> {
                    org.infinispan.configuration.cache.ConfigurationBuilder builder = (org.infinispan.configuration.cache.ConfigurationBuilder)entry.getValue();
                    builder.dataContainer().keyEquivalence((Equivalence)AnyEquivalence.getInstance());
                    clusteredCacheManager.defineConfiguration((String)entry.getKey(), HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)builder).build());
                });
                embeddedCacheManagers.add(clusteredCacheManager);
                hotRodServers.add(HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)clusteredCacheManager));
            }
            int port = ((HotRodServer)hotRodServers.get(0)).getAddress().port();
            Configuration build = new ConfigurationBuilder().addServer().port(port).host("localhost").build();
            return new Cluster(hotRodServers, embeddedCacheManagers, new RemoteCacheManager(build));
        }

        static class CacheDefinitionBuilder {
            private final Builder builder;
            private org.infinispan.configuration.cache.ConfigurationBuilder configurationBuilder;
            private String name;
            private String protocolVersion = "2.6";
            private Integer remotePort;

            CacheDefinitionBuilder(Builder builder) {
                this.builder = builder;
            }

            public CacheDefinitionBuilder name(String name) {
                this.name = name;
                return this;
            }

            CacheDefinitionBuilder remotePort(Integer remotePort) {
                this.remotePort = remotePort;
                return this;
            }

            CacheDefinitionBuilder remoteProtocolVersion(String remoteVersion) {
                this.protocolVersion = remoteVersion;
                return this;
            }

            CacheDefinitionBuilder configuredWith(org.infinispan.configuration.cache.ConfigurationBuilder configurationBuilder) {
                this.configurationBuilder = configurationBuilder;
                return this;
            }

            CacheDefinitionBuilder cache() {
                return this.addNewCache();
            }

            Cluster build() {
                this.addNewCache();
                return this.builder.build();
            }

            private CacheDefinitionBuilder addNewCache() {
                if (this.configurationBuilder == null) {
                    this.configurationBuilder = AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC);
                }
                if (this.remotePort != null) {
                    ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)this.configurationBuilder.persistence().addStore(RemoteStoreConfigurationBuilder.class)).hotRodWrapping(true).remoteCacheName(this.name).ignoreModifications(true)).protocolVersion(this.protocolVersion).addServer().host("localhost").port(this.remotePort.intValue());
                }
                this.builder.addCache(this.name, this.configurationBuilder);
                return new CacheDefinitionBuilder(this.builder);
            }
        }
    }
}

