/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.upgrade.TestCluster;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="upgrade.hotrod.HotRodUpgradeWithStoreTest", groups={"functional"})
public class HotRodUpgradeWithStoreTest
extends AbstractInfinispanTest {
    private TestCluster sourceCluster;
    private TestCluster targetCluster;
    private static final String CACHE_NAME = HotRodUpgradeWithStoreTest.class.getName();
    private static final int INITIAL_NUM_ENTRIES = 10;

    @BeforeClass
    public void setup() throws Exception {
        ConfigurationBuilder sourceStoreBuilder = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)sourceStoreBuilder.clustering().cacheMode(CacheMode.DIST_SYNC).locking().isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(true).versioning().scheme(VersioningScheme.SIMPLE).enable().persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).shared(true)).storeName("sourceStore");
        ConfigurationBuilder targetStoreBuilder = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)targetStoreBuilder.clustering().cacheMode(CacheMode.DIST_SYNC).locking().isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(true).versioning().scheme(VersioningScheme.SIMPLE).enable().persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).shared(true)).storeName("targetStore");
        this.sourceCluster = new TestCluster.Builder().setName("sourceCluster").setNumMembers(1).cache().name(CACHE_NAME).configuredWith(sourceStoreBuilder).build();
        this.targetCluster = new TestCluster.Builder().setName("targetCluster").setNumMembers(1).cache().name(CACHE_NAME).remotePort(this.sourceCluster.getHotRodPort()).configuredWith(targetStoreBuilder).build();
    }

    public void testSynchronization() throws Exception {
        RemoteCache<String, String> sourceRemoteCache = this.sourceCluster.getRemoteCache(CACHE_NAME);
        RemoteCache<String, String> targetRemoteCache = this.targetCluster.getRemoteCache(CACHE_NAME);
        IntStream.rangeClosed(1, 10).boxed().map(String::valueOf).forEach(s -> {
            String cfr_ignored_0 = (String)sourceRemoteCache.put(s, s, 10L, TimeUnit.MINUTES, 30L, TimeUnit.MINUTES);
        });
        AssertJUnit.assertEquals((int)10, (int)this.storeWrites(this.sourceCluster));
        AssertJUnit.assertEquals((String)"4", (String)((String)targetRemoteCache.get((Object)"4")));
        targetRemoteCache.put((Object)"8", (Object)"changed", 10L, TimeUnit.MINUTES, 30L, TimeUnit.MINUTES);
        targetRemoteCache.remove((Object)"5");
        targetRemoteCache.remove((Object)"1");
        targetRemoteCache.put((Object)"new key", (Object)"new value", 10L, TimeUnit.MINUTES, 30L, TimeUnit.MINUTES);
        AssertJUnit.assertEquals((int)9, (int)this.storeSize(this.sourceCluster));
        AssertJUnit.assertEquals((int)12, (int)this.storeWrites(this.sourceCluster));
        AssertJUnit.assertEquals((int)2, (int)this.storeSize(this.targetCluster));
        RollingUpgradeManager upgradeManager = this.targetCluster.getRollingUpgradeManager(CACHE_NAME);
        long migrated = upgradeManager.synchronizeData("hotrod", 10, 1);
        upgradeManager.disconnectSource("hotrod");
        AssertJUnit.assertEquals((long)9L, (long)migrated);
        AssertJUnit.assertEquals((int)this.sourceCluster.getEmbeddedCache(CACHE_NAME).size(), (int)this.targetCluster.getEmbeddedCache(CACHE_NAME).size());
        MetadataValue metadataValue = targetRemoteCache.getWithMetadata((Object)"10");
        AssertJUnit.assertEquals((int)600, (int)metadataValue.getLifespan());
        AssertJUnit.assertEquals((int)1800, (int)metadataValue.getMaxIdle());
        AssertJUnit.assertFalse((boolean)targetRemoteCache.containsKey((Object)"5"));
        AssertJUnit.assertFalse((boolean)targetRemoteCache.containsKey((Object)"1"));
        AssertJUnit.assertEquals((String)"4", (String)((String)targetRemoteCache.get((Object)"4")));
        AssertJUnit.assertEquals((String)"changed", (String)((String)targetRemoteCache.get((Object)"8")));
        AssertJUnit.assertEquals((String)"new value", (String)((String)targetRemoteCache.get((Object)"new key")));
        AssertJUnit.assertEquals((int)9, (int)this.storeSize(this.sourceCluster));
        AssertJUnit.assertEquals((int)9, (int)targetRemoteCache.size());
        AssertJUnit.assertEquals((int)9, (int)this.storeSize(this.targetCluster));
        AssertJUnit.assertEquals((int)12, (int)this.storeWrites(this.sourceCluster));
    }

    private DummyInMemoryStore getDummyStore(TestCluster testCluster) {
        PersistenceManager pm = (PersistenceManager)TestingUtil.extractComponent(testCluster.getEmbeddedCache(CACHE_NAME), PersistenceManager.class);
        return (DummyInMemoryStore)pm.getStores(DummyInMemoryStore.class).iterator().next();
    }

    private int storeSize(TestCluster cluster) {
        return this.getDummyStore(cluster).size();
    }

    private int storeWrites(TestCluster cluster) {
        return (Integer)this.getDummyStore(cluster).stats().get("write");
    }

    @AfterClass
    public void tearDown() {
        this.targetCluster.destroy();
        this.sourceCluster.destroy();
    }
}

