/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote;

import org.infinispan.Cache;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(testName="persistence.remote.RemoteStoreConfigTest", groups={"functional"})
public class RemoteStoreConfigTest {
    public static final String CACHE_LOADER_CONFIG = "remote-cl-config.xml";
    private EmbeddedCacheManager cacheManager;
    private HotRodServer hotRodServer;

    @BeforeTest
    public void startUp() {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        Assert.assertEquals((long)this.cacheManager.getCache().size(), (long)0L);
        this.hotRodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (int)19711);
    }

    public void simpleTest() throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)CACHE_LOADER_CONFIG)){

            public void call() {
                Cache cache = this.cm.getCache();
                CacheLoader cacheLoader = TestingUtil.getCacheLoader((Cache)cache);
                assert (cacheLoader != null);
                assert (cacheLoader instanceof RemoteStore);
                cache.put((Object)"k", (Object)"v");
                Assert.assertEquals((long)1L, (long)RemoteStoreConfigTest.this.cacheManager.getCache().size());
                cache.stop();
                Assert.assertEquals((long)1L, (long)RemoteStoreConfigTest.this.cacheManager.getCache().size());
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)CACHE_LOADER_CONFIG)){

            public void call() {
                Cache cache = this.cm.getCache();
                Assert.assertEquals((Object)"v", (Object)cache.get((Object)"k"));
            }
        });
    }

    @AfterTest
    public void tearDown() {
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotRodServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }
}

