/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="upgrade.hotrod.HotRodMultiServerUpdateSynchronizerTest", groups={"functional"})
public class HotRodMultiServerUpdateSynchronizerTest
extends AbstractInfinispanTest {
    private Cluster sourceCluster;
    private Cluster targetCluster;

    @BeforeClass
    public void setup() throws Exception {
        this.sourceCluster = this.buildCluster("sourceCluster", 2, null);
        this.targetCluster = this.buildCluster("targetCluster", 2, this.sourceCluster.hotRodServers.get(0).getPort());
    }

    public void testSynchronization() throws Exception {
        RemoteCache sourceRemoteCache = this.sourceCluster.remoteCache;
        RemoteCache targetRemoteCache = this.targetCluster.remoteCache;
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            String s = Character.toString(ch);
            sourceRemoteCache.put((Object)s, (Object)s, 20L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS);
        }
        AssertJUnit.assertEquals((String)"A", (String)((String)targetRemoteCache.get((Object)"A")));
        RollingUpgradeManager upgradeManager = this.targetCluster.getRollingUpgradeManager();
        long count = upgradeManager.synchronizeData("hotrod");
        AssertJUnit.assertEquals((long)26L, (long)count);
        AssertJUnit.assertEquals((int)this.sourceCluster.cache.size(), (int)this.targetCluster.cache.size());
        upgradeManager.disconnectSource("hotrod");
        MetadataValue metadataValue = targetRemoteCache.getWithMetadata((Object)"Z");
        AssertJUnit.assertEquals((int)20, (int)metadataValue.getLifespan());
        AssertJUnit.assertEquals((int)30, (int)metadataValue.getMaxIdle());
    }

    @AfterClass
    public void tearDown() {
        this.targetCluster.destroy();
        this.sourceCluster.destroy();
    }

    private Cluster buildCluster(String name, int numMembers, Integer remoteCachePort) {
        ArrayList<HotRodServer> hotRodServers = new ArrayList<HotRodServer>();
        ArrayList<EmbeddedCacheManager> embeddedCacheManagers = new ArrayList<EmbeddedCacheManager>();
        for (int i = 0; i < numMembers; ++i) {
            GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
            gcb.transport().defaultTransport().clusterName(name);
            org.infinispan.configuration.cache.ConfigurationBuilder defaultClusteredCacheConfig = AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC);
            if (remoteCachePort != null) {
                ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)defaultClusteredCacheConfig.persistence().addStore(RemoteStoreConfigurationBuilder.class)).hotRodWrapping(true).ignoreModifications(true)).addServer().host("localhost").port(remoteCachePort.intValue());
            }
            EmbeddedCacheManager clusteredCacheManager = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)gcb, (org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)defaultClusteredCacheConfig));
            embeddedCacheManagers.add(clusteredCacheManager);
            hotRodServers.add(HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)clusteredCacheManager));
        }
        int port = ((HotRodServer)hotRodServers.get(0)).getPort();
        Configuration build = new ConfigurationBuilder().addServer().port(port).host("localhost").build();
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(build);
        return new Cluster(hotRodServers, embeddedCacheManagers, remoteCacheManager);
    }

    private static class Cluster {
        private final RemoteCache<String, String> remoteCache;
        List<HotRodServer> hotRodServers;
        List<EmbeddedCacheManager> embeddedCacheManagers;
        RemoteCacheManager remoteCacheManager;
        private final Cache<String, String> cache;

        public Cluster(List<HotRodServer> hotRodServers, List<EmbeddedCacheManager> embeddedCacheManagers, RemoteCacheManager remoteCacheManager) {
            this.hotRodServers = hotRodServers;
            this.embeddedCacheManagers = embeddedCacheManagers;
            this.remoteCacheManager = remoteCacheManager;
            this.cache = embeddedCacheManagers.get(0).getCache();
            this.remoteCache = remoteCacheManager.getCache();
        }

        private void destroy() {
            this.embeddedCacheManagers.forEach(xva$0 -> TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{xva$0}));
            this.hotRodServers.forEach(xva$0 -> HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{xva$0}));
            HotRodClientTestingUtil.killRemoteCacheManagers((RemoteCacheManager[])new RemoteCacheManager[]{this.remoteCacheManager});
        }

        private RollingUpgradeManager getRollingUpgradeManager() {
            return (RollingUpgradeManager)this.embeddedCacheManagers.get(0).getCache().getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
        }
    }
}

