/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="upgrade.hotrod.HotRodUpgradeSynchronizerTest", groups={"functional"})
public class HotRodUpgradeSynchronizerTest
extends AbstractInfinispanTest {
    private HotRodServer sourceServer;
    private HotRodServer targetServer;
    private EmbeddedCacheManager sourceContainer;
    private Cache<byte[], byte[]> sourceServerDefaultCache;
    private Cache<byte[], byte[]> sourceServerAltCache;
    private EmbeddedCacheManager targetContainer;
    private Cache<byte[], byte[]> targetServerDefaultCache;
    private Cache<byte[], byte[]> targetServerAltCache;
    private RemoteCacheManager sourceRemoteCacheManager;
    private RemoteCache<String, String> sourceRemoteDefaultCache;
    private RemoteCache<String, String> sourceRemoteAltCache;
    private RemoteCacheManager targetRemoteCacheManager;
    private RemoteCache<String, String> targetRemoteDefaultCache;
    private RemoteCache<String, String> targetRemoteAltCache;
    private static final String ALT_CACHE_NAME = "whatever";
    private static final String OLD_PROTOCOL_VERSION = "2.0";

    @BeforeClass
    public void setup() throws Exception {
        ConfigurationBuilder serverBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        this.sourceContainer = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)serverBuilder));
        this.sourceServerDefaultCache = this.sourceContainer.getCache();
        this.sourceServerAltCache = this.sourceContainer.getCache(ALT_CACHE_NAME);
        this.sourceServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.sourceContainer);
        ConfigurationBuilder targetConfigurationBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)targetConfigurationBuilder.persistence().addStore(RemoteStoreConfigurationBuilder.class)).hotRodWrapping(true).ignoreModifications(true)).addServer().host("localhost").port(this.sourceServer.getPort());
        ConfigurationBuilder builderOldVersion = new ConfigurationBuilder();
        ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)builderOldVersion.persistence().addStore(RemoteStoreConfigurationBuilder.class)).hotRodWrapping(true).ignoreModifications(true)).remoteCacheName(ALT_CACHE_NAME).protocolVersion(OLD_PROTOCOL_VERSION).addServer().host("localhost").port(this.sourceServer.getPort());
        this.targetContainer = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)targetConfigurationBuilder));
        this.targetContainer.defineConfiguration(ALT_CACHE_NAME, HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)builderOldVersion).build());
        this.targetServerDefaultCache = this.targetContainer.getCache();
        this.targetServerAltCache = this.targetContainer.getCache(ALT_CACHE_NAME);
        this.targetServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.targetContainer);
        this.sourceRemoteCacheManager = new RemoteCacheManager("localhost", this.sourceServer.getPort());
        this.sourceRemoteCacheManager.start();
        this.sourceRemoteDefaultCache = this.sourceRemoteCacheManager.getCache();
        this.sourceRemoteAltCache = this.sourceRemoteCacheManager.getCache(ALT_CACHE_NAME);
        this.targetRemoteCacheManager = new RemoteCacheManager("localhost", this.targetServer.getPort());
        this.targetRemoteCacheManager.start();
        this.targetRemoteDefaultCache = this.targetRemoteCacheManager.getCache();
        this.targetRemoteAltCache = this.targetRemoteCacheManager.getCache(ALT_CACHE_NAME);
    }

    public void testSynchronizationViaIterator() throws Exception {
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            String s = Character.toString(ch);
            this.sourceRemoteDefaultCache.put((Object)s, (Object)s, 20L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS);
        }
        AssertJUnit.assertEquals((String)"A", (String)((String)this.targetRemoteDefaultCache.get((Object)"A")));
        RollingUpgradeManager targetUpgradeManager = (RollingUpgradeManager)this.targetServerDefaultCache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
        targetUpgradeManager.synchronizeData("hotrod");
        AssertJUnit.assertEquals((int)this.sourceServerDefaultCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).size(), (int)this.targetServerDefaultCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).size());
        targetUpgradeManager.disconnectSource("hotrod");
        MetadataValue metadataValue = this.targetRemoteDefaultCache.getWithMetadata((Object)"B");
        AssertJUnit.assertEquals((int)20, (int)metadataValue.getLifespan());
        AssertJUnit.assertEquals((int)30, (int)metadataValue.getMaxIdle());
    }

    public void testSynchronizationViaKeyRecording() throws Exception {
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            String s = Character.toString(ch);
            this.sourceRemoteAltCache.put((Object)s, (Object)s, 20L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS);
        }
        AssertJUnit.assertEquals((String)"A", (String)((String)this.targetRemoteAltCache.get((Object)"A")));
        RollingUpgradeManager sourceUpgradeManager = (RollingUpgradeManager)this.sourceServerAltCache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
        sourceUpgradeManager.recordKnownGlobalKeyset();
        RollingUpgradeManager targetUpgradeManager = (RollingUpgradeManager)this.targetServerAltCache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
        targetUpgradeManager.synchronizeData("hotrod");
        AssertJUnit.assertEquals((int)(this.sourceServerAltCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).size() - 1), (int)this.targetServerAltCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).size());
        targetUpgradeManager.disconnectSource("hotrod");
        MetadataValue metadataValue = this.targetRemoteAltCache.getWithMetadata((Object)"A");
        AssertJUnit.assertEquals((int)20, (int)metadataValue.getLifespan());
        AssertJUnit.assertEquals((int)30, (int)metadataValue.getMaxIdle());
    }

    @BeforeMethod
    public void cleanup() {
        this.sourceServerDefaultCache.clear();
        this.sourceServerAltCache.clear();
        this.targetServerDefaultCache.clear();
        this.targetServerAltCache.clear();
    }

    @AfterClass
    public void tearDown() {
        HotRodClientTestingUtil.killRemoteCacheManagers((RemoteCacheManager[])new RemoteCacheManager[]{this.sourceRemoteCacheManager, this.targetRemoteCacheManager});
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.sourceServer, this.targetServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.targetContainer, this.sourceContainer});
    }
}

