/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.reactivex.Flowable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.Util;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.keymappers.MarshallingTwoWayKey2StringMapper;
import org.infinispan.persistence.rest.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.rest.configuration.RestStoreConfiguration;
import org.infinispan.persistence.rest.logging.Log;
import org.infinispan.persistence.rest.metadata.MetadataHelper;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.LogFactory;

@Store(shared=true)
@ThreadSafe
@ConfiguredBy(value=RestStoreConfiguration.class)
public class RestStore<K, V>
implements AdvancedLoadWriteStore<K, V> {
    private static final String MAX_IDLE_TIME_SECONDS = "maxIdleTimeSeconds";
    private static final String TIME_TO_LIVE_SECONDS = "timeToLiveSeconds";
    private static final String CREATED = "created";
    private static final String LAST_USED = "lastUsed";
    private static final Log log = (Log)LogFactory.getLog(RestStore.class, Log.class);
    private volatile RestStoreConfiguration configuration;
    private Bootstrap bootstrap;
    private InternalEntryFactory iceFactory;
    private MarshallingTwoWayKey2StringMapper key2StringMapper;
    private String path;
    private MetadataHelper metadataHelper;
    private final URLCodec urlCodec = new URLCodec();
    private InitializationContext ctx;
    private StreamingMarshaller marshaller;
    private MarshallableEntryFactory<K, V> entryFactory;
    private EventLoopGroup workerGroup;
    private int maxContentLength;

    public void init(InitializationContext initializationContext) {
        this.configuration = (RestStoreConfiguration)initializationContext.getConfiguration();
        this.ctx = initializationContext;
        this.marshaller = this.ctx.getMarshaller();
        this.entryFactory = this.ctx.getMarshallableEntryFactory();
    }

    public void start() {
        if (this.iceFactory == null) {
            this.iceFactory = (InternalEntryFactory)this.ctx.getCache().getAdvancedCache().getComponentRegistry().getComponent(InternalEntryFactory.class);
        }
        ConnectionPoolConfiguration pool = this.configuration.connectionPool();
        this.workerGroup = new NioEventLoopGroup();
        Bootstrap b = (Bootstrap)((Bootstrap)new Bootstrap().group(this.workerGroup)).channel(NioSocketChannel.class);
        b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec()});
            }
        });
        b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)pool.connectionTimeout());
        b.option(ChannelOption.SO_SNDBUF, (Object)pool.bufferSize());
        b.option(ChannelOption.SO_RCVBUF, (Object)pool.bufferSize());
        b.option(ChannelOption.TCP_NODELAY, (Object)pool.tcpNoDelay());
        this.bootstrap = b;
        this.maxContentLength = this.configuration.maxContentLength();
        this.key2StringMapper = (MarshallingTwoWayKey2StringMapper)Util.getInstance((String)this.configuration.key2StringMapper(), (ClassLoader)this.ctx.getCache().getAdvancedCache().getClassLoader());
        this.key2StringMapper.setMarshaller(this.marshaller);
        this.path = this.configuration.path();
        try {
            if (this.configuration.appendCacheNameToPath()) {
                this.path = this.path + this.urlCodec.encode(this.ctx.getCache().getName()) + "/";
            }
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
        this.metadataHelper = (MetadataHelper)Util.getInstance((String)this.configuration.metadataHelper(), (ClassLoader)this.ctx.getCache().getAdvancedCache().getClassLoader());
        new HttpResponseHandler();
    }

    public void stop() {
        try {
            this.workerGroup.shutdownGracefully(100L, 15000L, TimeUnit.MILLISECONDS).sync();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalLifecycleStateException((Throwable)e);
        }
    }

    public boolean isAvailable() {
        try {
            DefaultHttpRequest get = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.path);
            HttpResponseHandler handler = new HttpResponseHandler(true);
            Channel ch = this.bootstrap.connect(this.configuration.host(), this.configuration.port()).awaitUninterruptibly().channel().pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxContentLength), handler}).channel();
            ch.writeAndFlush((Object)get).sync().channel().closeFuture().sync();
            return handler.getResponse().status().code() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setInternalCacheEntryFactory(InternalEntryFactory iceFactory) {
        if (this.iceFactory != null) {
            throw new IllegalStateException();
        }
        this.iceFactory = iceFactory;
    }

    private String keyToUri(Object key) {
        try {
            return this.path + this.urlCodec.encode(this.key2StringMapper.getStringMapping(key));
        }
        catch (EncoderException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private byte[] marshall(String contentType, MarshallableEntry entry) {
        if (this.configuration.rawValues()) {
            return (byte[])entry.getValue();
        }
        if (this.isTextContentType(contentType)) {
            return (byte[])entry.getValue();
        }
        return MarshallUtil.toByteArray((ByteBuffer)entry.getValueBytes());
    }

    private Object unmarshall(String contentType, byte[] b) throws IOException, ClassNotFoundException {
        if (this.configuration.rawValues()) {
            return b;
        }
        if (this.isTextContentType(contentType)) {
            return new String(b);
        }
        return this.marshaller.objectFromByteBuffer(b);
    }

    private boolean isTextContentType(String contentType) {
        return contentType != null && (contentType.startsWith("text/") || "application/xml".equals(contentType) || "application/json".equals(contentType));
    }

    public void write(MarshallableEntry entry) {
        try {
            String contentType = this.metadataHelper.getContentType(entry);
            ByteBuf content = Unpooled.wrappedBuffer((byte[])this.marshall(contentType, entry));
            DefaultFullHttpRequest put = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, this.keyToUri(entry.getKey()), content);
            put.headers().add("Content-Type", (Object)contentType);
            put.headers().add("Content-Length", (Object)content.readableBytes());
            Metadata metadata = entry.getMetadata();
            if (metadata != null && entry.expiryTime() > -1L) {
                put.headers().add(TIME_TO_LIVE_SECONDS, (Object)Long.toString(this.timeoutToSeconds(metadata.lifespan())));
                put.headers().add(MAX_IDLE_TIME_SECONDS, (Object)Long.toString(this.timeoutToSeconds(metadata.maxIdle())));
            }
            Channel ch = this.bootstrap.connect(this.configuration.host(), this.configuration.port()).awaitUninterruptibly().channel().pipeline().addLast(new ChannelHandler[]{new HttpResponseHandler()}).channel();
            ch.writeAndFlush((Object)put).sync().channel().closeFuture().sync();
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void clear() {
        DefaultHttpRequest delete = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.DELETE, this.path);
        try {
            Channel ch = this.bootstrap.connect(this.configuration.host(), this.configuration.port()).awaitUninterruptibly().channel().pipeline().addLast(new ChannelHandler[]{new HttpResponseHandler()}).channel();
            ch.writeAndFlush((Object)delete).sync().channel().closeFuture().sync();
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Object key) {
        boolean bl;
        DefaultHttpRequest delete = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.DELETE, this.keyToUri(key));
        HttpResponseHandler handler = new HttpResponseHandler(true);
        Channel ch = this.bootstrap.connect(this.configuration.host(), this.configuration.port()).awaitUninterruptibly().channel().pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxContentLength), handler}).channel();
        ch.writeAndFlush((Object)delete).sync().channel().closeFuture().sync();
        try {
            bl = this.isSuccessful(handler.getResponse().status().code());
        }
        catch (Throwable throwable) {
            try {
                handler.getResponse().release();
                throw throwable;
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        handler.getResponse().release();
        return bl;
    }

    public MarshallableEntry<K, V> loadEntry(Object key) {
        return this.load(key, true, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MarshallableEntry<K, V> load(Object key, boolean fetchValue, boolean fetchMetadata) {
        try {
            DefaultHttpHeaders headers = new DefaultHttpHeaders();
            DefaultHttpRequest get = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.keyToUri(key), (HttpHeaders)headers);
            HttpResponseHandler handler = new HttpResponseHandler(true);
            Channel ch = this.bootstrap.connect(this.configuration.host(), this.configuration.port()).awaitUninterruptibly().channel().pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxContentLength), handler}).channel();
            ch.writeAndFlush((Object)get).sync().channel().closeFuture().sync();
            FullHttpResponse response = handler.getResponse();
            try {
                if (HttpResponseStatus.OK.equals((Object)response.status())) {
                    Object value;
                    long lastUsed;
                    long created;
                    Metadata metadata;
                    String contentType = response.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
                    if (fetchMetadata) {
                        long ttl = this.timeHeaderToLong(response.headers().get(TIME_TO_LIVE_SECONDS));
                        long maxidle = this.timeHeaderToLong(response.headers().get(MAX_IDLE_TIME_SECONDS));
                        metadata = this.metadataHelper.buildMetadata(contentType, ttl, TimeUnit.SECONDS, maxidle, TimeUnit.SECONDS);
                        created = this.timeHeaderToLong(response.headers().get(CREATED));
                        lastUsed = this.timeHeaderToLong(response.headers().get(LAST_USED));
                    } else {
                        metadata = null;
                        created = -1L;
                        lastUsed = -1L;
                    }
                    if (fetchValue) {
                        ByteBuf content = response.content();
                        byte[] bytes = new byte[content.readableBytes()];
                        content.readBytes(bytes);
                        value = this.unmarshall(contentType, bytes);
                    } else {
                        value = null;
                    }
                    MarshallableEntry marshallableEntry = this.entryFactory.create(key, value, metadata, created, lastUsed);
                    return marshallableEntry;
                }
                if (!HttpResponseStatus.NOT_FOUND.equals((Object)response.status())) throw log.httpError(response.status().toString());
                MarshallableEntry<K, V> marshallableEntry = null;
                return marshallableEntry;
            }
            finally {
                response.release();
            }
        }
        catch (IOException e) {
            throw log.httpError(e);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private long timeoutToSeconds(long timeout) {
        if (timeout < 0L) {
            return -1L;
        }
        if (timeout > 0L && timeout < 1000L) {
            return 1L;
        }
        return TimeUnit.MILLISECONDS.toSeconds(timeout);
    }

    private long timeHeaderToLong(String header) {
        return header == null ? -1L : Long.parseLong(header);
    }

    public Flowable<K> publishKeys(Predicate<? super K> filter) {
        return Flowable.using(() -> {
            DefaultHttpRequest get = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.path + "?global");
            get.headers().add((CharSequence)HttpHeaderNames.ACCEPT, (Object)"text/plain");
            get.headers().add((CharSequence)HttpHeaderNames.ACCEPT_CHARSET, (Object)"UTF-8");
            HttpResponseHandler handler = new HttpResponseHandler(true);
            try {
                Channel ch = this.bootstrap.connect(this.configuration.host(), this.configuration.port()).awaitUninterruptibly().channel().pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxContentLength), handler}).channel();
                ch.writeAndFlush((Object)get).sync().channel().closeFuture().sync();
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteBufInputStream(handler.getResponse().content()), StandardCharsets.UTF_8));
                return new KeyValuePair((Object)handler.getResponse(), (Object)reader);
            }
            catch (Throwable t) {
                FullHttpResponse response = handler.getResponse();
                if (response != null) {
                    response.release();
                }
                throw t;
            }
        }, kvp -> Flowable.fromIterable(() -> new RestIterator((KeyValuePair<FullHttpResponse, BufferedReader>)kvp, filter)), kvp -> {
            try {
                ((BufferedReader)kvp.getValue()).close();
            }
            finally {
                ((FullHttpResponse)kvp.getKey()).release();
            }
        });
    }

    public Flowable<MarshallableEntry<K, V>> entryPublisher(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        Flowable<? super K> keyFlowable = this.publishKeys(filter);
        if (!fetchValue && !fetchMetadata) {
            return keyFlowable.map(k -> this.entryFactory.create(k));
        }
        return keyFlowable.map(k -> {
            MarshallableEntry entry = this.load(k, fetchValue, fetchMetadata);
            if (entry == null) {
                entry = this.entryFactory.getEmpty();
            }
            return entry;
        }).filter(me -> me != this.entryFactory.getEmpty());
    }

    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener purgeListener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int size() {
        Channel ch = null;
        DefaultHttpRequest get = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.path + "?global");
        get.headers().add("Accept", (Object)"text/plain");
        try {
            HttpResponseHandler handler = new HttpResponseHandler(true);
            ch = this.bootstrap.connect(this.configuration.host(), this.configuration.port()).awaitUninterruptibly().channel().pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxContentLength), handler}).channel();
            ch.writeAndFlush((Object)get).sync().channel().closeFuture().sync();
            try {
                int n;
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader((InputStream)new ByteBufInputStream(handler.getResponse().content())));
                    int count = 0;
                    while (reader.readLine() != null) {
                        ++count;
                    }
                    n = count;
                }
                catch (Throwable throwable) {
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return n;
            }
            finally {
                handler.getResponse().release();
            }
        }
        catch (Exception e) {
            throw log.errorLoadingRemoteEntries(e);
        }
    }

    public boolean contains(Object o) {
        return this.loadEntry(o) != null;
    }

    private boolean isSuccessful(int status) {
        return status >= 200 && status < 300;
    }

    private class RestIterator
    extends AbstractIterator<K> {
        private final KeyValuePair<FullHttpResponse, BufferedReader> kvp;
        private final Predicate<? super K> filter;

        public RestIterator(KeyValuePair<FullHttpResponse, BufferedReader> kvp, Predicate<? super K> filter) {
            this.kvp = kvp;
            this.filter = filter;
        }

        protected K getNext() {
            Object key = null;
            try {
                String stringKey;
                while (key == null && (stringKey = ((BufferedReader)this.kvp.getValue()).readLine()) != null) {
                    Object tmpkey = RestStore.this.key2StringMapper.getKeyMapping(stringKey);
                    if (this.filter != null && !this.filter.test(tmpkey)) continue;
                    key = tmpkey;
                }
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
            return key;
        }
    }

    private static class HttpResponseHandler
    extends SimpleChannelInboundHandler<HttpResponse> {
        private FullHttpResponse response;
        private boolean retainResponse;

        HttpResponseHandler() {
            this(false);
        }

        HttpResponseHandler(boolean retainResponse) {
            this.retainResponse = retainResponse;
        }

        protected void channelRead0(ChannelHandlerContext ctx, HttpResponse msg) throws Exception {
            if (this.retainResponse) {
                this.response = ((FullHttpResponse)msg).retain();
            }
            ctx.close();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            throw new PersistenceException(cause);
        }

        public FullHttpResponse getResponse() {
            return this.response;
        }
    }
}

