/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.configuration;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.NestingAttributeSerializer;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.persistence.keymappers.WrappedByteArrayOrPrimitiveMapper;
import org.infinispan.persistence.rest.RestStore;
import org.infinispan.persistence.rest.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.rest.configuration.Element;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationBuilder;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationSerializer;
import org.infinispan.persistence.rest.metadata.EmbeddedMetadataHelper;

@BuiltBy(value=RestStoreConfigurationBuilder.class)
@ConfigurationFor(value=RestStore.class)
@SerializedWith(value=RestStoreConfigurationSerializer.class)
public class RestStoreConfiguration
extends AbstractStoreConfiguration {
    private static NestingAttributeSerializer<Object, RestStoreConfiguration, RestStoreConfigurationBuilder> UNDER_SERVER_ELEMENT = new NestingAttributeSerializer(Element.SERVER.getLocalName());
    public static final AttributeDefinition<String> KEY2STRING_MAPPER = AttributeDefinition.builder((String)"key2StringMapper", (Object)WrappedByteArrayOrPrimitiveMapper.class.getName()).immutable().xmlName("key-to-string-mapper").build();
    public static final AttributeDefinition<String> METADATA_HELPER = AttributeDefinition.builder((String)"metadataHelper", (Object)EmbeddedMetadataHelper.class.getName()).immutable().build();
    public static final AttributeDefinition<String> HOST = AttributeDefinition.builder((String)"host", null, String.class).immutable().serializer(UNDER_SERVER_ELEMENT).autoPersist(false).build();
    public static final AttributeDefinition<Integer> PORT = AttributeDefinition.builder((String)"port", (Object)80).immutable().autoPersist(false).serializer(UNDER_SERVER_ELEMENT).build();
    public static final AttributeDefinition<String> PATH = AttributeDefinition.builder((String)"path", (Object)"/").immutable().build();
    public static final AttributeDefinition<Boolean> APPEND_CACHE_NAME_TO_PATH = AttributeDefinition.builder((String)"appendCacheNameToPath", (Object)false).immutable().build();
    public static final AttributeDefinition<Boolean> RAW_VALUES = AttributeDefinition.builder((String)"rawValues", (Object)false).immutable().build();
    public static final AttributeDefinition<Integer> MAX_CONTENT_LENGTH = AttributeDefinition.builder((String)"maxContentLength", (Object)0xA00000).immutable().build();
    private final List<ConfigurationInfo> subElements;
    static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.REST_STORE.getLocalName());
    private final Attribute<String> key2StringMapper;
    private final Attribute<String> metadataHelper;
    private final Attribute<String> host;
    private final Attribute<Integer> port;
    private final Attribute<String> path;
    private final Attribute<Boolean> appendCacheNameToPath;
    private final Attribute<Boolean> rawValues;
    private final Attribute<Integer> maxContentLength;
    private final ConnectionPoolConfiguration connectionPool;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RestStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{KEY2STRING_MAPPER, METADATA_HELPER, HOST, PORT, PATH, APPEND_CACHE_NAME_TO_PATH, RAW_VALUES, MAX_CONTENT_LENGTH});
    }

    public RestStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, ConnectionPoolConfiguration connectionPool) {
        super(attributes, async);
        this.key2StringMapper = attributes.attribute(KEY2STRING_MAPPER);
        this.metadataHelper = attributes.attribute(METADATA_HELPER);
        this.host = attributes.attribute(HOST);
        this.port = attributes.attribute(PORT);
        this.path = attributes.attribute(PATH);
        this.appendCacheNameToPath = attributes.attribute(APPEND_CACHE_NAME_TO_PATH);
        this.rawValues = attributes.attribute(RAW_VALUES);
        this.maxContentLength = attributes.attribute(MAX_CONTENT_LENGTH);
        this.connectionPool = connectionPool;
        this.subElements = new ArrayList<ConfigurationInfo>(super.subElements());
        this.subElements.add(connectionPool);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    public ConnectionPoolConfiguration connectionPool() {
        return this.connectionPool;
    }

    public String key2StringMapper() {
        return (String)this.key2StringMapper.get();
    }

    public String metadataHelper() {
        return (String)this.metadataHelper.get();
    }

    public String host() {
        return (String)this.host.get();
    }

    public int port() {
        return (Integer)this.port.get();
    }

    public String path() {
        return (String)this.path.get();
    }

    public boolean appendCacheNameToPath() {
        return (Boolean)this.appendCacheNameToPath.get();
    }

    public boolean rawValues() {
        return (Boolean)this.rawValues.get();
    }

    public int maxContentLength() {
        return (Integer)this.maxContentLength.get();
    }

    public String toString() {
        return "RestStoreConfiguration [connectionPool=" + this.connectionPool + ", attributes=" + this.attributes + "]";
    }
}

