/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.configuration;

import java.util.Collection;
import java.util.Collections;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.keymappers.MarshallingTwoWayKey2StringMapper;
import org.infinispan.persistence.rest.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.rest.configuration.RestStoreConfiguration;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationChildBuilder;
import org.infinispan.persistence.rest.logging.Log;
import org.infinispan.persistence.rest.metadata.MetadataHelper;
import org.infinispan.util.logging.LogFactory;

public class RestStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<RestStoreConfiguration, RestStoreConfigurationBuilder>
implements RestStoreConfigurationChildBuilder<RestStoreConfigurationBuilder>,
ConfigurationBuilderInfo {
    private static final Log log = (Log)LogFactory.getLog(RestStoreConfigurationBuilder.class, Log.class);
    private final ConnectionPoolConfigurationBuilder connectionPool = new ConnectionPoolConfigurationBuilder(this);

    public RestStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder, RestStoreConfiguration.attributeDefinitionSet());
    }

    public ElementDefinition getElementDefinition() {
        return RestStoreConfiguration.ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return Collections.singletonList(this.connectionPool);
    }

    public RestStoreConfigurationBuilder self() {
        return this;
    }

    @Override
    public ConnectionPoolConfigurationBuilder connectionPool() {
        return this.connectionPool;
    }

    @Override
    public RestStoreConfigurationBuilder host(String host) {
        this.attributes.attribute(RestStoreConfiguration.HOST).set((Object)host);
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder key2StringMapper(String key2StringMapper) {
        this.attributes.attribute(RestStoreConfiguration.KEY2STRING_MAPPER).set((Object)key2StringMapper);
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder key2StringMapper(Class<? extends MarshallingTwoWayKey2StringMapper> klass) {
        this.attributes.attribute(RestStoreConfiguration.KEY2STRING_MAPPER).set((Object)klass.getName());
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder metadataHelper(String metadataHelper) {
        this.attributes.attribute(RestStoreConfiguration.METADATA_HELPER).set((Object)metadataHelper);
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder metadataHelper(Class<? extends MetadataHelper> metadataHelper) {
        this.metadataHelper(metadataHelper.getName());
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder path(String path) {
        this.attributes.attribute(RestStoreConfiguration.PATH).set((Object)path);
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder port(int port) {
        this.attributes.attribute(RestStoreConfiguration.PORT).set((Object)port);
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder appendCacheNameToPath(boolean appendCacheNameToPath) {
        this.attributes.attribute(RestStoreConfiguration.APPEND_CACHE_NAME_TO_PATH).set((Object)appendCacheNameToPath);
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder rawValues(boolean rawValues) {
        this.attributes.attribute(RestStoreConfiguration.RAW_VALUES).set((Object)rawValues);
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder maxContentLength(int maxContentLength) {
        this.attributes.attribute(RestStoreConfiguration.MAX_CONTENT_LENGTH).set((Object)maxContentLength);
        return this;
    }

    public RestStoreConfiguration create() {
        return new RestStoreConfiguration(this.attributes.protect(), this.async.create(), this.connectionPool.create());
    }

    public RestStoreConfigurationBuilder read(RestStoreConfiguration template) {
        super.read((StoreConfiguration)template);
        this.connectionPool.read(template.connectionPool());
        return this;
    }

    public void validate() {
        this.connectionPool.validate();
        if (this.attributes.attribute(RestStoreConfiguration.HOST).get() == null) {
            throw log.hostNotSpecified();
        }
        String path = (String)this.attributes.attribute(RestStoreConfiguration.PATH).get();
        if (!path.endsWith("/")) {
            this.path(path + "/");
        }
    }
}

