/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest;

import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.BaseStoreFunctionalTest;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationBuilder;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(testName="persistence.remote.RestCacheStoreFunctionalTest", groups={"functional"})
public class RestCacheStoreFunctionalTest
extends BaseStoreFunctionalTest {
    private EmbeddedCacheManager localCacheManager;
    private RestServer restServer;

    protected PersistenceConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder loaders, boolean preload) {
        this.localCacheManager = TestCacheManagerFactory.createServerModeCacheManager();
        RestServerConfigurationBuilder restServerConfigurationBuilder = new RestServerConfigurationBuilder();
        restServerConfigurationBuilder.port(0);
        this.restServer = new RestServer();
        this.restServer.start((ProtocolServerConfiguration)restServerConfigurationBuilder.build(), this.cacheManager);
        ((RestStoreConfigurationBuilder)loaders.addStore(RestStoreConfigurationBuilder.class)).host("localhost").port(this.restServer.getPort().intValue()).path("/rest/" + this.getDefaultCacheName()).preload(preload);
        return loaders;
    }

    protected EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.createServerModeCacheManager();
    }

    protected void teardown() {
        super.teardown();
        if (this.restServer != null) {
            this.restServer.stop();
        }
        if (this.localCacheManager != null) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.localCacheManager});
        }
    }

    public void testPreloadAndExpiry() {
    }

    public void testPreloadStoredAsBinary() {
    }

    public void testTwoCachesSameCacheStore() {
    }
}

