/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.ParallelIterationTest;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationBuilder;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.rest.RestStoreParallelIterationTest")
public class RestStoreParallelIterationTest
extends ParallelIterationTest {
    private EmbeddedCacheManager localCacheManager;
    private RestServer restServer;

    protected void configurePersistence(ConfigurationBuilder cb) {
        this.localCacheManager = TestCacheManagerFactory.createServerModeCacheManager();
        RestServerConfigurationBuilder restServerConfigurationBuilder = new RestServerConfigurationBuilder();
        this.restServer = new RestServer();
        this.restServer.start((ProtocolServerConfiguration)restServerConfigurationBuilder.build(), this.localCacheManager);
        ((RestStoreConfigurationBuilder)cb.persistence().addStore(RestStoreConfigurationBuilder.class)).host("localhost").port(this.restServer.getPort().intValue()).path("/rest/" + TestingUtil.getDefaultCacheName((EmbeddedCacheManager)this.localCacheManager)).preload(false);
    }

    protected void teardown() {
        super.teardown();
        this.restServer.stop();
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.localCacheManager});
    }

    protected void assertMetadataEmpty(Metadata metadata) {
        if (metadata != null) {
            Assert.assertTrue((metadata.lifespan() < 0L ? 1 : 0) != 0);
            Assert.assertTrue((metadata.maxIdle() < 0L ? 1 : 0) != 0);
            Assert.assertNull((Object)metadata.version());
        }
    }
}

