/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest;

import java.io.IOException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.rest.RestStore;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationBuilder;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="persistence.rest.RestStoreTest", groups={"functional"})
public class RestStoreTest
extends BaseStoreTest {
    private static final String REMOTE_CACHE = "remote-cache";
    private EmbeddedCacheManager localCacheManager;
    private RestServer restServer;

    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder localBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        localBuilder.memory().evictionType(EvictionType.COUNT).size(120L).expiration().wakeUpInterval(10L);
        this.localCacheManager = TestCacheManagerFactory.createServerModeCacheManager((ConfigurationBuilder)localBuilder);
        this.localCacheManager.defineConfiguration(REMOTE_CACHE, this.localCacheManager.getDefaultCacheConfiguration());
        this.localCacheManager.getCache(REMOTE_CACHE);
        TestingUtil.replaceComponent((CacheContainer)this.localCacheManager, TimeService.class, (Object)this.timeService, (boolean)true);
        this.localCacheManager.getCache(REMOTE_CACHE).getAdvancedCache().getComponentRegistry().rewire();
        RestServerConfigurationBuilder restServerConfigurationBuilder = new RestServerConfigurationBuilder();
        restServerConfigurationBuilder.port(0);
        this.restServer = new RestServer();
        this.restServer.start((ProtocolServerConfiguration)restServerConfigurationBuilder.build(), this.localCacheManager);
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        RestStoreConfigurationBuilder storeConfigurationBuilder = (RestStoreConfigurationBuilder)builder.persistence().addStore(RestStoreConfigurationBuilder.class);
        storeConfigurationBuilder.host(this.restServer.getHost()).port(this.restServer.getPort().intValue()).path("/rest/remote-cache");
        storeConfigurationBuilder.connectionPool().maxTotalConnections(10).maxConnectionsPerHost(10);
        storeConfigurationBuilder.validate();
        RestStore restStore = new RestStore();
        restStore.init(this.createContext(builder.build()));
        return restStore;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        super.tearDown();
        if (this.restServer != null) {
            this.restServer.stop();
        }
        if (this.localCacheManager != null) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.localCacheManager});
        }
    }

    protected boolean storePurgesAllExpired() {
        return false;
    }

    public void testReplaceExpiredEntry() throws Exception {
        InternalCacheEntry ice = this.internalCacheEntry("k1", "v1", 100L);
        this.cl.write(this.marshalledEntry(ice));
        this.timeService.advance(1101L);
        AssertJUnit.assertNull((Object)this.cl.loadEntry((Object)"k1"));
        InternalCacheEntry ice2 = this.internalCacheEntry("k1", "v2", 100L);
        this.cl.write(this.marshalledEntry(ice2));
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cl.loadEntry((Object)"k1").getValue());
    }

    public void testLoadAndStoreImmortal() throws PersistenceException {
        super.testLoadAndStoreImmortal();
    }

    public void testLoadAndStoreWithLifespan() throws Exception {
        super.testLoadAndStoreWithLifespan();
    }

    public void testLoadAndStoreWithIdle() throws Exception {
        super.testLoadAndStoreWithIdle();
    }

    public void testLoadAndStoreWithLifespanAndIdle() throws Exception {
        super.testLoadAndStoreWithLifespanAndIdle();
    }

    public void testLoadAndStoreWithLifespanAndIdle2() throws Exception {
        super.testLoadAndStoreWithLifespanAndIdle2();
    }

    public void testStopStartDoesNotNukeValues() throws InterruptedException, PersistenceException {
        super.testStopStartDoesNotNukeValues();
    }

    public void testPreload() throws Exception {
        super.testPreload();
    }

    public void testStoreAndRemove() throws PersistenceException {
        super.testStoreAndRemove();
    }

    public void testPurgeExpired() throws Exception {
        super.testPurgeExpired();
    }

    public void testLoadAll() throws PersistenceException {
        super.testLoadAll();
    }

    public void testLoadAndStoreBytesValues() throws PersistenceException, IOException, InterruptedException {
        super.testLoadAndStoreBytesValues();
    }
}

