package org.infinispan.persistence.rest.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import org.jboss.logging.BasicLogger;
import org.infinispan.persistence.spi.PersistenceException;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-12-23T07:55:04+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void errorExecutingParallelStoreTask(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorExecutingParallelStoreTask$str());
    }
    private static final String errorExecutingParallelStoreTask = "ISPN000252: Error executing parallel store task";
    protected String errorExecutingParallelStoreTask$str() {
        return errorExecutingParallelStoreTask;
    }
    private static final String httpError1 = "ISPN022002: HTTP error: %s";
    protected String httpError1$str() {
        return httpError1;
    }
    @Override
    public final PersistenceException httpError(final String status) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), httpError1$str(), status));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String httpError0 = "ISPN022003: HTTP error";
    protected String httpError0$str() {
        return httpError0;
    }
    @Override
    public final PersistenceException httpError(final Throwable t) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), httpError0$str()), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String hostNotSpecified = "ISPN022004: Host not specified";
    protected String hostNotSpecified$str() {
        return hostNotSpecified;
    }
    @Override
    public final CacheConfigurationException hostNotSpecified() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), hostNotSpecified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorLoadingRemoteEntries = "ISPN022005: Error loading entries from remote server";
    protected String errorLoadingRemoteEntries$str() {
        return errorLoadingRemoteEntries;
    }
    @Override
    public final PersistenceException errorLoadingRemoteEntries(final Exception e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), errorLoadingRemoteEntries$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorGettingCacheSize = "ISPN022006: Error getting cache size";
    protected String errorGettingCacheSize$str() {
        return errorGettingCacheSize;
    }
    @Override
    public final PersistenceException errorGettingCacheSize(final Exception e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), errorGettingCacheSize$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cannotCloseClient(final Throwable e) {
        super.log.logf(FQCN, WARN, e, cannotCloseClient$str());
    }
    private static final String cannotCloseClient = "ISPN022007: Cound not close the REST client";
    protected String cannotCloseClient$str() {
        return cannotCloseClient;
    }
}
