/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.reactivex.Flowable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.Util;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.keymappers.MarshallingTwoWayKey2StringMapper;
import org.infinispan.persistence.rest.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.rest.configuration.RestStoreConfiguration;
import org.infinispan.persistence.rest.logging.Log;
import org.infinispan.persistence.rest.metadata.MetadataHelper;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.LogFactory;

@Store(shared=true)
@ThreadSafe
@ConfiguredBy(value=RestStoreConfiguration.class)
public class RestStore<K, V>
implements AdvancedLoadWriteStore<K, V> {
    private static final String MAX_IDLE_TIME_SECONDS = "maxIdleTimeSeconds";
    private static final String TIME_TO_LIVE_SECONDS = "timeToLiveSeconds";
    private static final String CREATED = "created";
    private static final String LAST_USED = "lastUsed";
    private static final Log log = (Log)LogFactory.getLog(RestStore.class, Log.class);
    private volatile RestStoreConfiguration configuration;
    private InternalEntryFactory iceFactory;
    private MarshallingTwoWayKey2StringMapper key2StringMapper;
    private MetadataHelper metadataHelper;
    private final URLCodec urlCodec = new URLCodec();
    private InitializationContext ctx;
    private Marshaller marshaller;
    private MarshallableEntryFactory<K, V> entryFactory;
    private RestClient client;
    private RestCacheClient cacheClient;
    private String initialCtxCache;

    public void init(InitializationContext initializationContext) {
        this.configuration = (RestStoreConfiguration)initializationContext.getConfiguration();
        this.ctx = initializationContext;
        this.marshaller = this.ctx.getPersistenceMarshaller();
        this.entryFactory = this.ctx.getMarshallableEntryFactory();
        this.initialCtxCache = initializationContext.getCache().getName();
    }

    public void start() {
        if (this.iceFactory == null) {
            this.iceFactory = (InternalEntryFactory)this.ctx.getCache().getAdvancedCache().getComponentRegistry().getComponent(InternalEntryFactory.class);
        }
        ConnectionPoolConfiguration pool = this.configuration.connectionPool();
        RestClientConfiguration clientConfig = new RestClientConfigurationBuilder().addServer().host(this.configuration.host()).port(this.configuration.port()).connectionTimeout((long)pool.connectionTimeout()).tcpNoDelay(pool.tcpNoDelay()).socketTimeout((long)pool.socketTimeout()).tcpKeepAlive(true).build();
        this.client = RestClient.forConfiguration((RestClientConfiguration)clientConfig);
        String cacheName = this.configuration.cacheName();
        if (cacheName == null) {
            cacheName = this.initialCtxCache;
        }
        this.cacheClient = this.client.cache(cacheName);
        this.key2StringMapper = (MarshallingTwoWayKey2StringMapper)Util.getInstance((String)this.configuration.key2StringMapper(), (ClassLoader)this.ctx.getCache().getAdvancedCache().getClassLoader());
        this.key2StringMapper.setMarshaller(this.marshaller);
        this.metadataHelper = (MetadataHelper)Util.getInstance((String)this.configuration.metadataHelper(), (ClassLoader)this.ctx.getCache().getAdvancedCache().getClassLoader());
    }

    public void stop() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            log.cannotCloseClient(e);
        }
    }

    public boolean isAvailable() {
        try {
            CompletionStage exists = this.cacheClient.exists();
            RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)exists);
            return response != null && response.getStatus() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String encodeKey(Object key) {
        try {
            return this.urlCodec.encode(this.key2StringMapper.getStringMapping(key));
        }
        catch (EncoderException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private byte[] marshall(String contentType, MarshallableEntry entry) {
        if (this.configuration.rawValues()) {
            return (byte[])entry.getValue();
        }
        if (this.isTextContentType(contentType)) {
            return (byte[])entry.getValue();
        }
        return MarshallUtil.toByteArray((ByteBuffer)entry.getValueBytes());
    }

    private Object unmarshall(String contentType, byte[] b) throws IOException, ClassNotFoundException {
        if (this.configuration.rawValues()) {
            return b;
        }
        if (this.isTextContentType(contentType)) {
            return new String(b);
        }
        return this.marshaller.objectFromByteBuffer(b);
    }

    private boolean isTextContentType(String contentType) {
        return contentType != null && (contentType.startsWith("text/") || "application/xml".equals(contentType) || "application/json".equals(contentType));
    }

    public void write(MarshallableEntry entry) {
        try {
            CompletionStage req;
            String contentType = this.metadataHelper.getContentType(entry);
            String key = this.encodeKey(entry.getKey());
            byte[] payload = this.marshall(contentType, entry);
            RestEntity restEntity = RestEntity.create((MediaType)MediaType.fromString((String)contentType), (byte[])payload);
            Metadata metadata = entry.getMetadata();
            if (metadata != null && entry.expiryTime() > -1L) {
                long ttl = this.timeoutToSeconds(metadata.lifespan());
                long maxIdle = this.timeoutToSeconds(metadata.maxIdle());
                req = this.cacheClient.put(key, restEntity, ttl, maxIdle);
            } else {
                req = this.cacheClient.put(key, restEntity);
            }
            RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)req);
            if (!this.isSuccessful(response.getStatus())) {
                throw new PersistenceException("Error writing entry");
            }
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void clear() {
        try {
            CompletionStage clear = this.cacheClient.clear();
            RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)clear);
            if (!this.isSuccessful(response.getStatus())) {
                throw new PersistenceException("Failed to clear remote store");
            }
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public boolean delete(Object key) {
        try {
            CompletionStage remove = this.cacheClient.remove(this.encodeKey(key));
            RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)remove);
            return this.isSuccessful(response.getStatus());
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public MarshallableEntry<K, V> loadEntry(Object key) {
        return this.load(key, true, true);
    }

    private String getHeader(String name, RestResponse restResponse) {
        List values = (List)restResponse.headers().get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.iterator().next();
    }

    private MarshallableEntry<K, V> load(Object key, boolean fetchValue, boolean fetchMetadata) {
        try (RestResponse response = null;){
            response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheClient.get(this.encodeKey(key)));
            if (this.isSuccessful(response.getStatus())) {
                Object value;
                long lastUsed;
                long created;
                Metadata metadata;
                String contentType = this.getHeader("Content-Type", response);
                if (fetchMetadata) {
                    long ttl = this.timeHeaderToLong(this.getHeader(TIME_TO_LIVE_SECONDS, response));
                    long maxidle = this.timeHeaderToLong(this.getHeader(MAX_IDLE_TIME_SECONDS, response));
                    metadata = this.metadataHelper.buildMetadata(contentType, ttl, TimeUnit.SECONDS, maxidle, TimeUnit.SECONDS);
                    created = this.timeHeaderToLong(this.getHeader(CREATED, response));
                    lastUsed = this.timeHeaderToLong(this.getHeader(LAST_USED, response));
                } else {
                    metadata = null;
                    created = -1L;
                    lastUsed = -1L;
                }
                if (fetchValue) {
                    byte[] bytes = response.getBodyAsByteArray();
                    value = this.unmarshall(contentType, bytes);
                } else {
                    value = null;
                }
                MarshallableEntry marshallableEntry = this.entryFactory.create(key, value, metadata, created, lastUsed);
                return marshallableEntry;
            }
            if (response.getStatus() == 404) {
                MarshallableEntry<K, V> contentType = null;
                return contentType;
            }
            try {
                throw log.httpError(String.valueOf(response.getStatus()));
            }
            catch (IOException e) {
                throw log.httpError(e);
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }
    }

    private long timeoutToSeconds(long timeout) {
        if (timeout < 0L) {
            return -1L;
        }
        if (timeout > 0L && timeout < 1000L) {
            return 1L;
        }
        return TimeUnit.MILLISECONDS.toSeconds(timeout);
    }

    private long timeHeaderToLong(String header) {
        return header == null ? -1L : Long.parseLong(header);
    }

    public Flowable<K> publishKeys(Predicate<? super K> filter) {
        return Flowable.using(() -> {
            RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheClient.keys());
            return new BufferedReader(new InputStreamReader(response.getBodyAsStream()));
        }, kvp -> Flowable.fromIterable(() -> new RestIterator((BufferedReader)kvp, filter)), BufferedReader::close);
    }

    public Flowable<MarshallableEntry<K, V>> entryPublisher(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        Flowable<? super K> keyFlowable = this.publishKeys(filter);
        if (!fetchValue && !fetchMetadata) {
            return keyFlowable.map(k -> this.entryFactory.create(k));
        }
        return keyFlowable.map(k -> {
            MarshallableEntry entry = this.load(k, fetchValue, fetchMetadata);
            if (entry == null) {
                entry = this.entryFactory.getEmpty();
            }
            return entry;
        }).filter(me -> me != this.entryFactory.getEmpty());
    }

    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener purgeListener) {
    }

    public int size() {
        try {
            RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheClient.size());
            String sizeContent = response.getBody();
            try {
                return Integer.parseInt(sizeContent);
            }
            catch (NumberFormatException e) {
                throw log.errorGettingCacheSize(e);
            }
        }
        catch (Exception e) {
            throw log.errorLoadingRemoteEntries(e);
        }
    }

    public boolean contains(Object o) {
        return this.loadEntry(o) != null;
    }

    private boolean isSuccessful(int status) {
        return status >= 200 && status < 300;
    }

    private class RestIterator
    extends AbstractIterator<K> {
        private final Predicate<? super K> filter;
        private JsonParser jp;

        RestIterator(BufferedReader reader, Predicate<? super K> filter) {
            this.filter = filter;
            try {
                this.jp = new JsonFactory().createJsonParser((Reader)reader);
                JsonToken token = this.jp.nextToken();
                if (token == null) {
                    throw new CacheException("empty response from keys");
                }
                if (!JsonToken.START_ARRAY.equals((Object)token)) {
                    throw new CacheException("empty response from keys");
                }
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }

        protected K getNext() {
            Object key = null;
            try {
                while (key == null && !JsonToken.END_ARRAY.equals((Object)this.jp.nextToken())) {
                    Object tmpKey = RestStore.this.key2StringMapper.getKeyMapping(this.jp.getText());
                    if (this.filter != null && !this.filter.test(tmpKey)) continue;
                    key = tmpKey;
                }
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
            return key;
        }
    }
}

