/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.configuration;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.persistence.keymappers.WrappedByteArrayOrPrimitiveMapper;
import org.infinispan.persistence.rest.RestStore;
import org.infinispan.persistence.rest.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.rest.configuration.Element;
import org.infinispan.persistence.rest.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationBuilder;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationSerializer;
import org.infinispan.persistence.rest.metadata.EmbeddedMetadataHelper;

@BuiltBy(value=RestStoreConfigurationBuilder.class)
@ConfigurationFor(value=RestStore.class)
@SerializedWith(value=RestStoreConfigurationSerializer.class)
public class RestStoreConfiguration
extends AbstractStoreConfiguration {
    public static final AttributeDefinition<String> KEY2STRING_MAPPER = AttributeDefinition.builder((String)"key2StringMapper", (Object)WrappedByteArrayOrPrimitiveMapper.class.getName()).immutable().xmlName("key-to-string-mapper").build();
    public static final AttributeDefinition<String> METADATA_HELPER = AttributeDefinition.builder((String)"metadataHelper", (Object)EmbeddedMetadataHelper.class.getName()).immutable().build();
    public static final AttributeDefinition<String> CACHE_NAME = AttributeDefinition.builder((String)"cacheName", null, String.class).immutable().build();
    public static final AttributeDefinition<Boolean> RAW_VALUES = AttributeDefinition.builder((String)"rawValues", (Object)false).immutable().build();
    public static final AttributeDefinition<Integer> MAX_CONTENT_LENGTH = AttributeDefinition.builder((String)"maxContentLength", (Object)0xA00000).immutable().build();
    private final List<ConfigurationInfo> subElements;
    static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.REST_STORE.getLocalName());
    private final Attribute<String> key2StringMapper;
    private final Attribute<String> metadataHelper;
    private final Attribute<String> cacheName;
    private final Attribute<Boolean> rawValues;
    private final Attribute<Integer> maxContentLength;
    private final ConnectionPoolConfiguration connectionPool;
    private final RemoteServerConfiguration remoteServer;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RestStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{KEY2STRING_MAPPER, METADATA_HELPER, CACHE_NAME, RAW_VALUES, MAX_CONTENT_LENGTH});
    }

    public RestStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, ConnectionPoolConfiguration connectionPool, RemoteServerConfiguration remoteServer) {
        super(attributes, async);
        this.key2StringMapper = attributes.attribute(KEY2STRING_MAPPER);
        this.metadataHelper = attributes.attribute(METADATA_HELPER);
        this.cacheName = attributes.attribute(CACHE_NAME);
        this.rawValues = attributes.attribute(RAW_VALUES);
        this.maxContentLength = attributes.attribute(MAX_CONTENT_LENGTH);
        this.connectionPool = connectionPool;
        this.remoteServer = remoteServer;
        this.subElements = new ArrayList<ConfigurationInfo>(super.subElements());
        this.subElements.add(remoteServer);
        this.subElements.add(connectionPool);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    public ConnectionPoolConfiguration connectionPool() {
        return this.connectionPool;
    }

    public RemoteServerConfiguration remoteServer() {
        return this.remoteServer;
    }

    public String key2StringMapper() {
        return (String)this.key2StringMapper.get();
    }

    public String metadataHelper() {
        return (String)this.metadataHelper.get();
    }

    public String host() {
        return this.remoteServer.host();
    }

    public int port() {
        return this.remoteServer.port();
    }

    public String cacheName() {
        return (String)this.cacheName.get();
    }

    public boolean rawValues() {
        return (Boolean)this.rawValues.get();
    }

    public int maxContentLength() {
        return (Integer)this.maxContentLength.get();
    }

    public String toString() {
        return "RestStoreConfiguration{connectionPool=" + this.connectionPool + ", remoteServer=" + this.remoteServer + ", attributes=" + this.attributes + '}';
    }
}

