/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.persistence.rest.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteServerConfigurationBuilder
implements ConfigurationBuilderInfo,
Builder<RemoteServerConfiguration> {
    private static final Log log = (Log)LogFactory.getLog(RemoteServerConfigurationBuilder.class, Log.class);
    private final AttributeSet attributes = RemoteServerConfiguration.attributeDefinitionSet();

    public ElementDefinition getElementDefinition() {
        return RemoteServerConfiguration.ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public RemoteServerConfigurationBuilder host(String host) {
        this.attributes.attribute(RemoteServerConfiguration.HOST).set((Object)host);
        return this;
    }

    public RemoteServerConfigurationBuilder port(int port) {
        this.attributes.attribute(RemoteServerConfiguration.PORT).set((Object)port);
        return this;
    }

    public RemoteServerConfiguration create() {
        return new RemoteServerConfiguration(this.attributes.protect());
    }

    public Builder<?> read(RemoteServerConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public void validate() {
        if (this.attributes.attribute(RemoteServerConfiguration.HOST).get() == null) {
            throw log.hostNotSpecified();
        }
    }
}

