/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest;

import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.io.ByteBufferFactoryImpl;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.InternalEntryFactoryImpl;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.marshall.core.MarshalledEntryFactoryImpl;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.DummyInitializationContext;
import org.infinispan.persistence.rest.RestStore;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationBuilder;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.rest.EmbeddedRestServer;
import org.infinispan.rest.RestTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="persistence.remote.RemoteCacheStoreTest", groups={"functional"})
public class RestStoreTest
extends BaseStoreTest {
    private static final String REMOTE_CACHE = "remote-cache";
    private EmbeddedCacheManager localCacheManager;
    private EmbeddedRestServer restServer;

    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder cb = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        cb.eviction().maxEntries(100).strategy(EvictionStrategy.UNORDERED).expiration().wakeUpInterval(10L);
        GlobalConfigurationBuilder globalConfig = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalConfig.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(true));
        this.localCacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)globalConfig, (ConfigurationBuilder)cb);
        this.localCacheManager.getCache(REMOTE_CACHE);
        this.restServer = RestTestingUtil.startRestServer((EmbeddedCacheManager)this.localCacheManager);
        RestStoreConfigurationBuilder storeConfigurationBuilder = (RestStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(RestStoreConfigurationBuilder.class);
        storeConfigurationBuilder.host(this.restServer.getHost()).port(this.restServer.getPort()).path("/rest/remote-cache");
        storeConfigurationBuilder.connectionPool().maxTotalConnections(10).maxConnectionsPerHost(10);
        storeConfigurationBuilder.validate();
        RestStore restStore = new RestStore();
        restStore.init((InitializationContext)new DummyInitializationContext((StoreConfiguration)storeConfigurationBuilder.create(), this.getCache(), this.getMarshaller(), (ByteBufferFactory)new ByteBufferFactoryImpl(), (MarshalledEntryFactory)new MarshalledEntryFactoryImpl(this.getMarshaller())));
        InternalEntryFactoryImpl iceFactory = new InternalEntryFactoryImpl();
        iceFactory.injectTimeService(TIME_SERVICE);
        restStore.setInternalCacheEntryFactory((InternalEntryFactory)iceFactory);
        restStore.start();
        return restStore;
    }

    @AfterMethod
    public void tearDown() {
        RestTestingUtil.killServers((EmbeddedRestServer[])new EmbeddedRestServer[]{this.restServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.localCacheManager});
    }

    protected void assertEventuallyExpires(String key) throws Exception {
        for (int i = 0; i < 10 && this.cl.load((Object)"k") != null; ++i) {
            Thread.sleep(1000L);
        }
        assert (this.cl.load((Object)"k") == null);
    }

    protected void sleepForStopStartTest() throws InterruptedException {
        Thread.sleep(3000L);
    }

    protected void purgeExpired() {
        this.localCacheManager.getCache().getAdvancedCache().getEvictionManager().processEviction();
    }

    public void testReplaceExpiredEntry() throws Exception {
        InternalCacheEntry ice = TestInternalCacheEntryFactory.create((Object)"k1", (Object)"v1", (long)100L);
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)ice, (StreamingMarshaller)this.getMarshaller()));
        TestingUtil.sleepThread((long)1100L);
        assert (null == this.cl.load((Object)"k1"));
        InternalCacheEntry ice2 = TestInternalCacheEntryFactory.create((Object)"k1", (Object)"v2", (long)100L);
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)ice2, (StreamingMarshaller)this.getMarshaller()));
        assert (this.cl.load((Object)"k1").getValue().equals("v2"));
    }
}

