/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.configuration;

import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.rest.RestStore;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.rest.EmbeddedRestServer;
import org.infinispan.rest.RestTestingUtil;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(testName="persistence.remote.RestCacheStoreConfigTest", groups={"functional"})
public class RestCacheStoreConfigTest {
    public static final String CACHE_LOADER_CONFIG = "rest-cl-config.xml";
    private EmbeddedCacheManager cacheManager;
    private EmbeddedRestServer restServer;

    @BeforeTest
    public void startUp() {
        this.cacheManager = TestCacheManagerFactory.createCacheManager();
        Assert.assertEquals((long)this.cacheManager.getCache().size(), (long)0L);
        this.restServer = RestTestingUtil.startRestServer((EmbeddedCacheManager)this.cacheManager, (int)18212);
    }

    public void simpleTest() throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)CACHE_LOADER_CONFIG)){

            public void call() {
                Cache cache = this.cm.getCache();
                CacheLoader cacheLoader = TestingUtil.getCacheLoader((Cache)cache);
                AssertJUnit.assertSame(RestStore.class, cacheLoader.getClass());
                cache.put((Object)"k", (Object)"v");
                Assert.assertEquals((long)1L, (long)RestCacheStoreConfigTest.this.cacheManager.getCache().size());
                cache.stop();
                Assert.assertEquals((long)1L, (long)RestCacheStoreConfigTest.this.cacheManager.getCache().size());
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)CACHE_LOADER_CONFIG)){

            public void call() {
                Cache cache = this.cm.getCache();
                Assert.assertEquals((Object)"v", (Object)cache.get((Object)"k"));
            }
        });
    }

    @AfterTest
    public void tearDown() {
        RestTestingUtil.killServers((EmbeddedRestServer[])new EmbeddedRestServer[]{this.restServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }
}

