/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.configuration;

import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.keymappers.MarshalledValueOrPrimitiveMapper;
import org.infinispan.persistence.keymappers.MarshallingTwoWayKey2StringMapper;
import org.infinispan.persistence.rest.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.rest.configuration.RestStoreConfiguration;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationChildBuilder;
import org.infinispan.persistence.rest.logging.Log;
import org.infinispan.persistence.rest.metadata.EmbeddedMetadataHelper;
import org.infinispan.persistence.rest.metadata.MetadataHelper;
import org.infinispan.util.logging.LogFactory;

public class RestStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<RestStoreConfiguration, RestStoreConfigurationBuilder>
implements RestStoreConfigurationChildBuilder<RestStoreConfigurationBuilder> {
    private static final Log log = (Log)LogFactory.getLog(RestStoreConfigurationBuilder.class, Log.class);
    private final ConnectionPoolConfigurationBuilder connectionPool;
    private String key2StringMapper = MarshalledValueOrPrimitiveMapper.class.getName();
    private String metadataHelper = EmbeddedMetadataHelper.class.getName();
    private String path = "/";
    private String host;
    private int port = 80;
    private boolean appendCacheNameToPath = false;
    private boolean rawValues = false;

    public RestStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
        this.connectionPool = new ConnectionPoolConfigurationBuilder(this);
    }

    public RestStoreConfigurationBuilder self() {
        return this;
    }

    @Override
    public ConnectionPoolConfigurationBuilder connectionPool() {
        return this.connectionPool;
    }

    @Override
    public RestStoreConfigurationBuilder host(String host) {
        this.host = host;
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder key2StringMapper(String key2StringMapper) {
        this.key2StringMapper = key2StringMapper;
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder key2StringMapper(Class<? extends MarshallingTwoWayKey2StringMapper> klass) {
        this.key2StringMapper = klass.getName();
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder metadataHelper(String metadataHelper) {
        this.metadataHelper = metadataHelper;
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder metadataHelper(Class<? extends MetadataHelper> metadataHelper) {
        this.metadataHelper = metadataHelper.getName();
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder path(String path) {
        this.path = path;
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder port(int port) {
        this.port = port;
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder appendCacheNameToPath(boolean appendCacheNameToPath) {
        this.appendCacheNameToPath = appendCacheNameToPath;
        return this;
    }

    @Override
    public RestStoreConfigurationBuilder rawValues(boolean rawValues) {
        this.rawValues = rawValues;
        return this;
    }

    public RestStoreConfiguration create() {
        return new RestStoreConfiguration(this.purgeOnStartup, this.fetchPersistentState, this.ignoreModifications, this.async.create(), this.singletonStore.create(), this.preload, this.shared, this.properties, this.connectionPool.create(), this.key2StringMapper, this.metadataHelper, this.host, this.port, this.path, this.appendCacheNameToPath, this.rawValues);
    }

    public RestStoreConfigurationBuilder read(RestStoreConfiguration template) {
        super.read((StoreConfiguration)template);
        this.connectionPool.read(template.connectionPool());
        this.host = template.host();
        this.port = template.port();
        this.path = template.path();
        this.appendCacheNameToPath = template.appendCacheNameToPath();
        this.key2StringMapper = template.key2StringMapper();
        this.metadataHelper = template.metadataHelper();
        this.rawValues = template.rawValues();
        return this;
    }

    public void validate() {
        this.connectionPool.validate();
        if (this.host == null) {
            throw log.hostNotSpecified();
        }
        if (!this.path.endsWith("/")) {
            this.path = this.path + "/";
        }
    }
}

