/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.ParallelIterationTest;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationBuilder;
import org.infinispan.rest.EmbeddedRestServer;
import org.infinispan.rest.RestTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.rest.RestStoreParallelIterationTest")
public class RestStoreParallelIterationTest
extends ParallelIterationTest {
    private EmbeddedCacheManager localCacheManager;
    private EmbeddedRestServer restServer;

    protected void configurePersistence(ConfigurationBuilder cb) {
        this.localCacheManager = TestCacheManagerFactory.createCacheManager();
        this.restServer = RestTestingUtil.startRestServer((EmbeddedCacheManager)this.localCacheManager);
        ((RestStoreConfigurationBuilder)cb.persistence().addStore(RestStoreConfigurationBuilder.class)).host("localhost").port(this.restServer.getPort()).path("/rest/___defaultcache").preload(false);
    }

    protected void teardown() {
        super.teardown();
        RestTestingUtil.killServers((EmbeddedRestServer[])new EmbeddedRestServer[]{this.restServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.localCacheManager});
    }

    protected int numThreads() {
        return KnownComponentNames.getDefaultThreads((String)"org.infinispan.executors.persistence") + 1;
    }

    protected void assertMetadataEmpty(InternalMetadata metadata) {
        if (metadata != null) {
            Assert.assertTrue((metadata.created() < 0L ? 1 : 0) != 0);
            Assert.assertTrue((metadata.lastUsed() < 0L ? 1 : 0) != 0);
            Assert.assertTrue((metadata.lifespan() < 0L ? 1 : 0) != 0);
            Assert.assertTrue((metadata.maxIdle() < 0L ? 1 : 0) != 0);
            Assert.assertNull((Object)metadata.version());
        }
    }
}

