/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.upgrade;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationBuilder;
import org.infinispan.persistence.rest.metadata.MimeMetadataHelper;
import org.infinispan.rest.EmbeddedRestServer;
import org.infinispan.rest.RestTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="persistence.rest.upgrade.RestUpgradeSynchronizerTest", groups={"functional"})
public class RestUpgradeSynchronizerTest
extends AbstractInfinispanTest {
    private EmbeddedRestServer sourceServer;
    private EmbeddedRestServer targetServer;
    private EmbeddedCacheManager sourceContainer;
    private Cache<byte[], byte[]> sourceServerCache;
    private EmbeddedCacheManager targetContainer;
    private Cache<byte[], byte[]> targetServerCache;
    private HttpClient client;

    @BeforeClass
    public void setup() throws Exception {
        ConfigurationBuilder serverBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        this.sourceContainer = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)serverBuilder);
        this.sourceServerCache = this.sourceContainer.getCache();
        this.sourceServer = RestTestingUtil.startRestServer((EmbeddedCacheManager)this.sourceContainer);
        ConfigurationBuilder targetConfigurationBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        ((RestStoreConfigurationBuilder)targetConfigurationBuilder.persistence().addStore(RestStoreConfigurationBuilder.class)).host("localhost").port(this.sourceServer.getPort()).path("/rest/___defaultcache").metadataHelper(MimeMetadataHelper.class).rawValues(true).locking().isolationLevel(IsolationLevel.NONE);
        this.targetContainer = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)targetConfigurationBuilder);
        this.targetServerCache = this.targetContainer.getCache();
        this.targetServer = RestTestingUtil.startRestServer((EmbeddedCacheManager)this.targetContainer, (int)(this.sourceServer.getPort() + 10));
        this.client = new HttpClient();
    }

    public void testSynchronization() throws Exception {
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            String s = Character.toString(ch);
            PutMethod put = new PutMethod(String.format("http://localhost:%d/rest/%s/%s", this.sourceServer.getPort(), "___defaultcache", s));
            put.setRequestEntity((RequestEntity)new StringRequestEntity(s, "text/plain", "UTF-8"));
            AssertJUnit.assertEquals((int)200, (int)this.client.executeMethod((HttpMethod)put));
        }
        GetMethod get = new GetMethod(String.format("http://localhost:%d/rest/%s/A", this.targetServer.getPort(), "___defaultcache"));
        AssertJUnit.assertEquals((int)200, (int)this.client.executeMethod((HttpMethod)get));
        AssertJUnit.assertEquals((String)"A", (String)get.getResponseBodyAsString());
        RollingUpgradeManager sourceUpgradeManager = (RollingUpgradeManager)this.sourceServerCache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
        sourceUpgradeManager.recordKnownGlobalKeyset();
        RollingUpgradeManager targetUpgradeManager = (RollingUpgradeManager)this.targetServerCache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
        targetUpgradeManager.synchronizeData("rest");
        AssertJUnit.assertEquals((int)this.sourceServerCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).size(), (int)this.targetServerCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).size());
        targetUpgradeManager.disconnectSource("rest");
    }

    @BeforeMethod
    public void cleanup() {
        this.sourceServerCache.clear();
        this.targetServerCache.clear();
    }

    @AfterClass
    public void tearDown() {
        ((SimpleHttpConnectionManager)this.client.getHttpConnectionManager()).shutdown();
        RestTestingUtil.killServers((EmbeddedRestServer[])new EmbeddedRestServer[]{this.sourceServer, this.targetServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.targetContainer, this.sourceContainer});
    }
}

