/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.configuration;

import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.rest.RestStore;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="persistence.remote.RestCacheStoreConfigTest", groups={"functional"})
public class RestCacheStoreConfigTest
extends AbstractInfinispanTest {
    public static final String CACHE_LOADER_CONFIG = "rest-cl-config.xml";
    private EmbeddedCacheManager cacheManager;
    private RestServer restServer;

    @BeforeClass
    public void startUp() {
        this.cacheManager = TestCacheManagerFactory.createCacheManager();
        AssertJUnit.assertEquals((int)this.cacheManager.getCache().size(), (int)0);
        RestServerConfigurationBuilder restServerConfigurationBuilder = new RestServerConfigurationBuilder();
        restServerConfigurationBuilder.port(18212);
        this.restServer = new RestServer();
        this.restServer.start((ProtocolServerConfiguration)restServerConfigurationBuilder.build(), this.cacheManager);
    }

    public void simpleTest() throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)CACHE_LOADER_CONFIG)){

            public void call() {
                Cache cache = this.cm.getCache();
                CacheLoader cacheLoader = TestingUtil.getCacheLoader((Cache)cache);
                AssertJUnit.assertSame(RestStore.class, cacheLoader.getClass());
                cache.put((Object)"k", (Object)"v");
                AssertJUnit.assertEquals((int)1, (int)RestCacheStoreConfigTest.this.cacheManager.getCache().size());
                cache.stop();
                AssertJUnit.assertEquals((int)1, (int)RestCacheStoreConfigTest.this.cacheManager.getCache().size());
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)CACHE_LOADER_CONFIG)){

            public void call() {
                Cache cache = this.cm.getCache();
                AssertJUnit.assertEquals((Object)"v", (Object)cache.get((Object)"k"));
            }
        });
    }

    @AfterClass
    public void tearDown() {
        this.restServer.stop();
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }
}

