/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.configuration;

import java.util.List;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.rest.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.rest.configuration.RestStoreConfiguration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.rest.configuration.XmlFileParsingTest")
public class XmlFileParsingTest
extends AbstractInfinispanTest {
    public static final String CACHE_LOADER_CONFIG = "rest-cl-config.xml";
    private EmbeddedCacheManager cacheManager;

    @AfterMethod
    public void cleanup() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    public void testRemoteCacheStore() throws Exception {
        this.cacheManager = TestCacheManagerFactory.fromXml((String)CACHE_LOADER_CONFIG);
        List cacheLoaders = this.cacheManager.getDefaultCacheConfiguration().persistence().stores();
        AssertJUnit.assertEquals((int)1, (int)cacheLoaders.size());
        RestStoreConfiguration store = (RestStoreConfiguration)cacheLoaders.get(0);
        AssertJUnit.assertFalse((boolean)store.appendCacheNameToPath());
        AssertJUnit.assertEquals((String)"localhost", (String)store.host());
        AssertJUnit.assertEquals((String)"/rest/___defaultcache/", (String)store.path());
        AssertJUnit.assertEquals((int)18212, (int)store.port());
        AssertJUnit.assertEquals((int)15000000, (int)store.maxContentLength());
        ConnectionPoolConfiguration connectionPool = store.connectionPool();
        AssertJUnit.assertEquals((int)10000, (int)connectionPool.connectionTimeout());
        AssertJUnit.assertEquals((int)10, (int)connectionPool.maxConnectionsPerHost());
        AssertJUnit.assertEquals((int)10, (int)connectionPool.maxTotalConnections());
        AssertJUnit.assertEquals((int)20000, (int)connectionPool.bufferSize());
        AssertJUnit.assertEquals((int)10000, (int)connectionPool.socketTimeout());
        AssertJUnit.assertTrue((boolean)connectionPool.tcpNoDelay());
        AssertJUnit.assertFalse((boolean)store.async().enabled());
    }
}

