/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.NestingAttributeSerializer;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.persistence.rocksdb.RocksDBStore;
import org.infinispan.persistence.rocksdb.configuration.CompressionType;
import org.infinispan.persistence.rocksdb.configuration.Element;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationSerializer;

@ConfigurationFor(value=RocksDBStore.class)
@BuiltBy(value=RocksDBStoreConfigurationBuilder.class)
@SerializedWith(value=RocksDBStoreConfigurationSerializer.class)
public class RocksDBStoreConfiguration
extends AbstractStoreConfiguration
implements ConfigurationInfo {
    private static AttributeSerializer UNDER_EXPIRATION = new NestingAttributeSerializer(Element.EXPIRATION.getLocalName());
    static final AttributeDefinition<String> LOCATION = AttributeDefinition.builder((String)"location", (Object)"Infinispan-RocksDBStore/data").immutable().xmlName("path").build();
    static final AttributeDefinition<String> EXPIRED_LOCATION = AttributeDefinition.builder((String)"expiredLocation", (Object)"Infinispan-RocksDBStore/expired").immutable().autoPersist(false).xmlName("path").serializer(UNDER_EXPIRATION).build();
    static final AttributeDefinition<CompressionType> COMPRESSION_TYPE = AttributeDefinition.builder((String)"compressionType", (Object)((Object)CompressionType.NONE)).immutable().autoPersist(false).build();
    static final AttributeDefinition<Integer> BLOCK_SIZE = AttributeDefinition.builder((String)"blockSize", (Object)0).immutable().build();
    static final AttributeDefinition<Long> CACHE_SIZE = AttributeDefinition.builder((String)"cacheSize", (Object)0L).immutable().build();
    static final AttributeDefinition<Integer> EXPIRY_QUEUE_SIZE = AttributeDefinition.builder((String)"expiryQueueSize", (Object)10000).immutable().autoPersist(false).serializer(UNDER_EXPIRATION).build();
    static final AttributeDefinition<Integer> CLEAR_THRESHOLD = AttributeDefinition.builder((String)"clearThreshold", (Object)10000).immutable().build();
    public static ElementDefinition ELEMENT_DEFINTION = new DefaultElementDefinition(Element.ROCKSDB_STORE.getLocalName());
    private final Attribute<String> location;
    private final Attribute<String> expiredLocation;
    private final Attribute<CompressionType> compressionType;
    private final Attribute<Integer> blockSize;
    private final Attribute<Long> cacheSize;
    private final Attribute<Integer> expiryQueueSize;
    private final Attribute<Integer> clearThreshold;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RocksDBStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{LOCATION, EXPIRED_LOCATION, COMPRESSION_TYPE, BLOCK_SIZE, CACHE_SIZE, EXPIRY_QUEUE_SIZE, CLEAR_THRESHOLD});
    }

    public RocksDBStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async) {
        super(attributes, async);
        this.location = attributes.attribute(LOCATION);
        this.expiredLocation = attributes.attribute(EXPIRED_LOCATION);
        this.compressionType = attributes.attribute(COMPRESSION_TYPE);
        this.blockSize = attributes.attribute(BLOCK_SIZE);
        this.cacheSize = attributes.attribute(CACHE_SIZE);
        this.expiryQueueSize = attributes.attribute(EXPIRY_QUEUE_SIZE);
        this.clearThreshold = attributes.attribute(CLEAR_THRESHOLD);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINTION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String location() {
        return (String)this.location.get();
    }

    public String expiredLocation() {
        return (String)this.expiredLocation.get();
    }

    public CompressionType compressionType() {
        return (CompressionType)((Object)this.compressionType.get());
    }

    public Integer blockSize() {
        return (Integer)this.blockSize.get();
    }

    public Long cacheSize() {
        return (Long)this.cacheSize.get();
    }

    public int expiryQueueSize() {
        return (Integer)this.expiryQueueSize.get();
    }

    public int clearThreshold() {
        return (Integer)this.clearThreshold.get();
    }
}

