/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb;

import java.io.File;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.persistence.MultiStoresFunctionalTest;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.rocksdb.RocksDBMultiCacheStoreFunctionalTest")
public class RocksDBMultiCacheStoreFunctionalTest
extends MultiStoresFunctionalTest<RocksDBStoreConfigurationBuilder> {
    private File tmpDir = new File(TestingUtil.tmpDirectory(((Object)((Object)this)).getClass()));

    @BeforeMethod
    protected void cleanDataFiles() {
        if (this.tmpDir.exists()) {
            Util.recursiveFileRemove((File)this.tmpDir);
        }
    }

    protected RocksDBStoreConfigurationBuilder buildCacheStoreConfig(PersistenceConfigurationBuilder p, String discriminator) throws Exception {
        RocksDBStoreConfigurationBuilder store = (RocksDBStoreConfigurationBuilder)p.addStore(RocksDBStoreConfigurationBuilder.class);
        store.location(this.tmpDir.getAbsolutePath() + File.separator + "rocksdb" + File.separator + "data-" + discriminator);
        store.expiredLocation(this.tmpDir.getAbsolutePath() + File.separator + "rocksdb" + File.separator + "expired-data-" + discriminator);
        return store;
    }
}

