/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.HashFunctionPartitioner;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.rocksdb.RocksDBStore;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.util.PersistenceMockUtil;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.rocksdb.RocksDBStoreTest")
public class RocksDBStoreTest
extends BaseStoreTest {
    private String tmpDirectory = CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
    private Configuration configuration;
    private KeyPartitioner keyPartitioner;
    private boolean segmented;

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    public RocksDBStoreTest segmented(boolean segmented) {
        this.segmented = segmented;
        return this;
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new RocksDBStoreTest().segmented(false), new RocksDBStoreTest().segmented(true)};
    }

    protected String parameters() {
        return "[" + this.segmented + "]";
    }

    protected RocksDBStoreConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder lcb) {
        RocksDBStoreConfigurationBuilder cfg = (RocksDBStoreConfigurationBuilder)lcb.addStore(RocksDBStoreConfigurationBuilder.class);
        cfg.segmented(this.segmented);
        cfg.location(this.tmpDirectory);
        cfg.expiredLocation(this.tmpDirectory);
        cfg.clearThreshold(2);
        return cfg;
    }

    protected AdvancedLoadWriteStore createStore() {
        this.clearTempDir();
        RocksDBStore fcs = new RocksDBStore();
        ConfigurationBuilder cb = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        cb.clustering().hash().numSegments(16);
        this.createCacheStoreConfig(cb.persistence());
        this.configuration = cb.build();
        ClassWhiteList whiteList = this.marshaller.getWhiteList();
        InitializationContext ctx = PersistenceMockUtil.createContext(((Object)((Object)this)).getClass(), (Configuration)this.configuration, (PersistenceMarshaller)this.getMarshaller(), (TimeService)this.timeService, (ClassWhiteList)whiteList);
        Cache cache = ctx.getCache();
        HashFunctionPartitioner partitioner = new HashFunctionPartitioner();
        partitioner.init(cache.getCacheConfiguration().clustering().hash());
        this.keyPartitioner = partitioner;
        cache.getAdvancedCache().getComponentRegistry().registerComponent((Object)partitioner, KeyPartitioner.class);
        fcs.init(ctx);
        return fcs;
    }

    @Test(groups={"stress"}, timeOut=900000L)
    public void testConcurrentWriteAndRestart() {
        this.concurrentWriteAndRestart(true);
    }

    @Test(groups={"stress"}, timeOut=900000L)
    public void testConcurrentWriteAndStop() {
        this.concurrentWriteAndRestart(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concurrentWriteAndRestart(boolean start) {
        int THREADS = 4;
        AtomicBoolean run = new AtomicBoolean(true);
        AtomicInteger writtenPre = new AtomicInteger();
        AtomicInteger writtenPost = new AtomicInteger();
        AtomicBoolean post = new AtomicBoolean(false);
        CountDownLatch started = new CountDownLatch(4);
        CountDownLatch finished = new CountDownLatch(4);
        int i = 0;
        while (i < 4) {
            int thread = i++;
            this.fork(() -> {
                try {
                    started.countDown();
                    int i1 = 0;
                    while (run.get()) {
                        InternalCacheEntry entry = TestInternalCacheEntryFactory.create((Object)("k" + i1), (Object)("v" + i1));
                        MarshallableEntry me = MarshalledEntryUtil.create((InternalCacheEntry)entry, (Marshaller)this.getMarshaller());
                        try {
                            int prev;
                            AtomicInteger record = post.get() ? writtenPost : writtenPre;
                            this.cl.write(me);
                            ++i1;
                            while (((prev = record.get()) & 1 << thread) == 0) {
                                if (record.compareAndSet(prev, prev | 1 << thread)) continue;
                            }
                        }
                        catch (PersistenceException persistenceException) {}
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)"Failed", (Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    finished.countDown();
                }
            });
        }
        try {
            if (!started.await(30L, TimeUnit.SECONDS)) {
                Assert.fail();
            }
            Thread.sleep(1000L);
            this.cl.stop();
            post.set(true);
            Thread.sleep(1000L);
            if (start) {
                this.cl.start();
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        finally {
            run.set(false);
        }
        try {
            if (!finished.await(30L, TimeUnit.SECONDS)) {
                Assert.fail();
            }
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        Assert.assertEquals((int)writtenPre.get(), (int)15, (String)"pre");
        if (start) {
            Assert.assertEquals((int)writtenPost.get(), (int)15, (String)"post");
        } else {
            Assert.assertEquals((int)writtenPost.get(), (int)0, (String)"post");
        }
    }

    public void testSegmentsRemovedAndAdded() {
        String key = "first-key";
        String value = "some-value";
        int segment = this.keyPartitioner.getSegment((Object)key);
        InternalCacheEntry entry = TestInternalCacheEntryFactory.create((Object)key, (Object)value);
        MarshallableEntry me = MarshalledEntryUtil.create((InternalCacheEntry)entry, (Marshaller)this.getMarshaller());
        this.cl.write(me);
        Assert.assertTrue((boolean)this.cl.contains((Object)key));
        SegmentedAdvancedLoadWriteStore salws = (SegmentedAdvancedLoadWriteStore)this.cl;
        salws.removeSegments(IntSets.immutableSet((int)segment));
        Assert.assertFalse((boolean)this.cl.contains((Object)key));
        salws.addSegments(IntSets.immutableSet((int)segment));
        this.cl.write(me);
        Assert.assertTrue((boolean)this.cl.contains((Object)key));
    }
}

