/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.IdentityKeyValueWrapper;
import org.infinispan.persistence.PersistenceCompatibilityTest;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.rocksdb.RocksDBStoreCompatibilityTest")
public class RocksDBStoreCompatibilityTest
extends PersistenceCompatibilityTest<String> {
    private static final String DATA_10_1_FOLDER = Paths.get("10_1_x_rocksdb_data", "data").toString();
    private static final String EXPIRED_10_1_FOLDER = Paths.get("10_1_x_rocksdb_data", "expired").toString();
    private static final String[] DATA_10_1_FILES = new String[]{"000003_log", "CURRENT", "IDENTITY", "LOCK", "LOG", "MANIFEST-000001", "OPTIONS-000005"};

    public RocksDBStoreCompatibilityTest() {
        super(IdentityKeyValueWrapper.instance());
    }

    protected void beforeStartCache() throws Exception {
        Path dataLocation = this.getStoreLocation(this.combinePath(this.tmpDirectory, "data"), "data");
        Path expiredLocation = this.getStoreLocation(this.combinePath(this.tmpDirectory, "expired"), "expired");
        dataLocation.toFile().mkdirs();
        expiredLocation.toFile().mkdirs();
        String[] stringArray = DATA_10_1_FILES;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String filename;
            String dstFile = filename = stringArray[i];
            if (filename.endsWith("_log")) {
                dstFile = filename.replace("_log", ".log");
            }
            RocksDBStoreCompatibilityTest.copyFile((String)this.combinePath(DATA_10_1_FOLDER, filename), (Path)dataLocation, (String)dstFile);
            RocksDBStoreCompatibilityTest.copyFile((String)this.combinePath(EXPIRED_10_1_FOLDER, filename), (Path)expiredLocation, (String)dstFile);
        }
    }

    protected String cacheName() {
        return "rocksdb-cache-store";
    }

    protected void configurePersistence(ConfigurationBuilder builder) {
        ((RocksDBStoreConfigurationBuilder)((RocksDBStoreConfigurationBuilder)builder.persistence().addStore(RocksDBStoreConfigurationBuilder.class)).segmented(false)).location(this.combinePath(this.tmpDirectory, "data")).expiredLocation(this.combinePath(this.tmpDirectory, "expired"));
    }
}

