/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.BaseNonBlockingStoreTest;
import org.infinispan.persistence.rocksdb.RocksDBStore;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.rocksdb.RocksDBStoreTest")
public class RocksDBStoreTest
extends BaseNonBlockingStoreTest {
    private String tmpDirectory = CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
    private boolean segmented;

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    public RocksDBStoreTest segmented(boolean segmented) {
        this.segmented = segmented;
        return this;
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new RocksDBStoreTest().segmented(false), new RocksDBStoreTest().segmented(true)};
    }

    protected String parameters() {
        return "[" + this.segmented + "]";
    }

    protected Configuration buildConfig(ConfigurationBuilder cb) {
        cb.clustering().hash().numSegments(16);
        this.createCacheStoreConfig(cb.persistence());
        return cb.build();
    }

    protected RocksDBStoreConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder lcb) {
        RocksDBStoreConfigurationBuilder cfg = (RocksDBStoreConfigurationBuilder)lcb.addStore(RocksDBStoreConfigurationBuilder.class);
        cfg.segmented(this.segmented);
        cfg.location(this.tmpDirectory);
        cfg.expiredLocation(this.tmpDirectory);
        cfg.clearThreshold(2);
        return cfg;
    }

    protected NonBlockingStore createStore() {
        this.clearTempDir();
        return new RocksDBStore();
    }

    @Test(groups={"stress"})
    public void testConcurrentWrite() throws InterruptedException {
        int THREADS = 8;
        AtomicBoolean run = new AtomicBoolean(true);
        AtomicInteger written = new AtomicInteger();
        CountDownLatch started = new CountDownLatch(8);
        CountDownLatch finished = new CountDownLatch(8);
        int i = 0;
        while (i < 8) {
            int thread = i++;
            this.fork(() -> {
                try {
                    started.countDown();
                    int i1 = 0;
                    while (run.get()) {
                        InternalCacheEntry entry = TestInternalCacheEntryFactory.create((Object)("k" + i1), (Object)("v" + i1));
                        MarshallableEntry me = MarshalledEntryUtil.create((InternalCacheEntry)entry, (Marshaller)this.getMarshaller());
                        try {
                            int prev;
                            this.store.write(me);
                            ++i1;
                            while (((prev = written.get()) & 1 << thread) == 0) {
                                if (written.compareAndSet(prev, prev | 1 << thread)) continue;
                            }
                        }
                        catch (PersistenceException persistenceException) {}
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)"Failed", (Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    finished.countDown();
                }
            });
        }
        if (finished.await(1L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Test shouldn't have finished yet");
        }
        run.set(false);
        if (!finished.await(30L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Test should have finished!");
        }
        Assert.assertEquals((int)written.get(), (int)255, (String)"pre");
    }

    public void testSegmentsRemovedAndAdded() {
        String key = "first-key";
        String value = "some-value";
        int segment = this.keyPartitioner.getSegment((Object)key);
        InternalCacheEntry entry = TestInternalCacheEntryFactory.create((Object)key, (Object)value);
        MarshallableEntry me = MarshalledEntryUtil.create((InternalCacheEntry)entry, (Marshaller)this.getMarshaller());
        this.store.write(me);
        Assert.assertTrue((boolean)this.store.contains((Object)key));
        CompletionStages.join((CompletionStage)this.store.removeSegments(IntSets.immutableSet((int)segment)));
        Assert.assertFalse((boolean)this.store.contains((Object)key));
        CompletionStages.join((CompletionStage)this.store.addSegments(IntSets.immutableSet((int)segment)));
        this.store.write(me);
        Assert.assertTrue((boolean)this.store.contains((Object)key));
    }
}

