/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb;

import io.reactivex.rxjava3.core.Flowable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.BaseNonBlockingStoreTest;
import org.infinispan.persistence.rocksdb.RocksDBStore;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.reactivestreams.Publisher;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.rocksdb.RocksDBStoreTest")
public class RocksDBStoreTest
extends BaseNonBlockingStoreTest {
    private String tmpDirectory = CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
    private boolean segmented;
    public static final String KEY_1 = "key1";
    public static final String KEY_2 = "key2";

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    public RocksDBStoreTest segmented(boolean segmented) {
        this.segmented = segmented;
        return this;
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new RocksDBStoreTest().segmented(false), new RocksDBStoreTest().segmented(true)};
    }

    protected String parameters() {
        return "[" + this.segmented + "]";
    }

    protected Configuration buildConfig(ConfigurationBuilder cb) {
        cb.clustering().hash().numSegments(16);
        this.createCacheStoreConfig(cb.persistence());
        return cb.build();
    }

    protected RocksDBStoreConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder lcb) {
        RocksDBStoreConfigurationBuilder cfg = (RocksDBStoreConfigurationBuilder)lcb.addStore(RocksDBStoreConfigurationBuilder.class);
        cfg.segmented(this.segmented);
        cfg.location(this.tmpDirectory);
        cfg.expiredLocation(this.tmpDirectory);
        cfg.clearThreshold(2);
        return cfg;
    }

    protected NonBlockingStore createStore() {
        this.clearTempDir();
        return new RocksDBStore();
    }

    @Test(groups={"stress"})
    public void testConcurrentWrite() throws InterruptedException {
        int THREADS = 8;
        AtomicBoolean run = new AtomicBoolean(true);
        AtomicInteger written = new AtomicInteger();
        CountDownLatch started = new CountDownLatch(8);
        CountDownLatch finished = new CountDownLatch(8);
        int i = 0;
        while (i < 8) {
            int thread = i++;
            this.fork(() -> {
                try {
                    started.countDown();
                    int i1 = 0;
                    while (run.get()) {
                        InternalCacheEntry entry = TestInternalCacheEntryFactory.create((Object)("k" + i1), (Object)("v" + i1));
                        MarshallableEntry me = MarshalledEntryUtil.create((InternalCacheEntry)entry, (Marshaller)this.getMarshaller());
                        try {
                            int prev;
                            this.store.write(me);
                            ++i1;
                            while (((prev = written.get()) & 1 << thread) == 0) {
                                if (written.compareAndSet(prev, prev | 1 << thread)) continue;
                            }
                        }
                        catch (PersistenceException persistenceException) {}
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)"Failed", (Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    finished.countDown();
                }
            });
        }
        if (finished.await(1L, TimeUnit.SECONDS)) {
            AssertJUnit.fail((String)"Test shouldn't have finished yet");
        }
        run.set(false);
        if (!finished.await(30L, TimeUnit.SECONDS)) {
            AssertJUnit.fail((String)"Test should have finished!");
        }
        AssertJUnit.assertEquals((String)"pre", (int)255, (int)written.get());
    }

    public void testSegmentsRemovedAndAdded() {
        int segment1 = this.keyPartitioner.getSegment((Object)KEY_1);
        MarshallableEntry me1 = this.marshallableEntryFactory.create((Object)KEY_1, (Object)"value1");
        this.store.write(me1);
        AssertJUnit.assertTrue((boolean)((Boolean)CompletionStages.join((CompletionStage)this.store.containsKey(segment1, (Object)KEY_1))));
        int segment2 = this.keyPartitioner.getSegment((Object)KEY_2);
        AssertJUnit.assertTrue((segment1 != segment2 ? 1 : 0) != 0);
        MarshallableEntry me2 = this.marshallableEntryFactory.create((Object)KEY_2, (Object)"value2");
        this.store.write(me2);
        AssertJUnit.assertTrue((boolean)((Boolean)CompletionStages.join((CompletionStage)this.store.containsKey(segment2, (Object)KEY_2))));
        AssertJUnit.assertEquals(Arrays.asList(KEY_1, KEY_2), this.listKeys(null));
        this.store.removeSegments(IntSets.immutableSet((int)segment1));
        AssertJUnit.assertEquals((long)0L, (long)((Long)CompletionStages.join((CompletionStage)this.store.size(IntSets.immutableSet((int)segment1)))));
        AssertJUnit.assertFalse((boolean)((Boolean)CompletionStages.join((CompletionStage)this.store.containsKey(segment1, (Object)KEY_1))));
        this.assertEmpty(IntSets.immutableSet((int)segment1));
        AssertJUnit.assertTrue((boolean)((Boolean)CompletionStages.join((CompletionStage)this.store.containsKey(segment2, (Object)KEY_2))));
        AssertJUnit.assertEquals((long)1L, (long)((Long)CompletionStages.join((CompletionStage)this.store.size(IntSets.immutableSet((int)segment2)))));
        AssertJUnit.assertEquals(Collections.singletonList(KEY_2), this.listKeys(null));
        CompletionStages.join((CompletionStage)this.store.addSegments(IntSets.immutableSet((int)segment1)));
        this.store.write(me1);
        AssertJUnit.assertTrue((boolean)this.store.contains((Object)KEY_1));
        AssertJUnit.assertEquals(Arrays.asList(KEY_1, KEY_2), this.listKeys(null));
    }

    public void testClear() {
        MarshallableEntry me1 = this.marshallableEntryFactory.create((Object)KEY_1, (Object)"value");
        this.store.write(1, me1);
        AssertJUnit.assertTrue((boolean)((Boolean)CompletionStages.join((CompletionStage)this.store.containsKey(1, (Object)KEY_1))));
        int keySize = 10000;
        byte[] keyBytes = new byte[keySize];
        Arrays.fill(keyBytes, (byte)-1);
        byte[] valueBytes = new byte[]{};
        MarshallableEntry me2 = this.marshallableEntryFactory.create((ByteBuffer)ByteBufferImpl.create((byte[])keyBytes), (ByteBuffer)ByteBufferImpl.create((byte[])valueBytes));
        this.store.write(1, me2);
        this.store.clear();
        AssertJUnit.assertFalse((boolean)((Boolean)CompletionStages.join((CompletionStage)this.store.containsKey(1, (Object)KEY_1))));
        this.assertEmpty(null);
    }

    private void assertEmpty(IntSet segments) {
        AssertJUnit.assertEquals((long)0L, (long)((Long)CompletionStages.join((CompletionStage)this.store.size(segments))));
        AssertJUnit.assertEquals(Collections.emptyList(), this.listKeys(segments));
    }

    private List<Object> listKeys(IntSet segments) {
        return (List)Flowable.fromPublisher((Publisher)this.store.publishEntries(segments, null, true)).map(MarshallableEntry::getKey).toSortedList().blockingGet();
    }
}

