/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb.config;

import java.io.IOException;
import java.net.URL;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfiguration;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.rocksdb.configuration.ConfigurationTest")
public class ConfigurationTest
extends AbstractInfinispanTest {
    private String tmpDirectory = CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
    private String tmpDataDirectory = this.tmpDirectory + "/data";
    private String tmpExpiredDirectory = this.tmpDirectory + "/expired";

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    public void testConfigBuilder() {
        GlobalConfiguration globalConfig = new GlobalConfigurationBuilder().transport().defaultTransport().globalState().persistentLocation(this.tmpDirectory).build();
        Configuration cacheConfig = ((RocksDBStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(RocksDBStoreConfigurationBuilder.class)).location(this.tmpDataDirectory).expiredLocation(this.tmpExpiredDirectory).build();
        StoreConfiguration cacheLoaderConfig = (StoreConfiguration)cacheConfig.persistence().stores().get(0);
        AssertJUnit.assertTrue((boolean)(cacheLoaderConfig instanceof RocksDBStoreConfiguration));
        RocksDBStoreConfiguration rocksdbConfig = (RocksDBStoreConfiguration)cacheLoaderConfig;
        AssertJUnit.assertEquals((String)this.tmpDataDirectory, (String)rocksdbConfig.location());
        AssertJUnit.assertEquals((String)this.tmpExpiredDirectory, (String)rocksdbConfig.expiredLocation());
        DefaultCacheManager cacheManager = new DefaultCacheManager(globalConfig);
        cacheManager.defineConfiguration("testCache", cacheConfig);
        cacheManager.start();
        Cache cache = cacheManager.getCache("testCache");
        cache.put((Object)"hello", (Object)"there");
        cache.stop();
        cacheManager.stop();
    }

    public void testXmlConfig() throws IOException {
        URL config = ConfigurationTest.class.getResource("/config/rocksdb-config.xml");
        ConfigurationBuilderHolder configHolder = new ParserRegistry().parse(config);
        Configuration cacheConfig = ((ConfigurationBuilder)configHolder.getNamedConfigurationBuilders().get("testCache")).build();
        AssertJUnit.assertFalse((boolean)cacheConfig.persistence().passivation());
        AssertJUnit.assertEquals((int)cacheConfig.persistence().stores().size(), (int)1);
        StoreConfiguration cacheLoaderConfig = (StoreConfiguration)cacheConfig.persistence().stores().get(0);
        AssertJUnit.assertFalse((boolean)cacheLoaderConfig.shared());
        AssertJUnit.assertTrue((boolean)cacheLoaderConfig.preload());
        AssertJUnit.assertTrue((boolean)(cacheLoaderConfig instanceof RocksDBStoreConfiguration));
        RocksDBStoreConfiguration rocksdbConfig = (RocksDBStoreConfiguration)cacheLoaderConfig;
        AssertJUnit.assertEquals((String)"/tmp/rocksdb/52/data", (String)rocksdbConfig.location());
        AssertJUnit.assertEquals((String)"/tmp/rocksdb/52/expired", (String)rocksdbConfig.expiredLocation());
    }
}

