/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.IdentityKeyValueWrapper;
import org.infinispan.persistence.PersistenceCompatibilityTest;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.test.data.Value;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.rocksdb.RocksDBStoreCompatibilityTest")
public class RocksDBStoreCompatibilityTest
extends PersistenceCompatibilityTest<Value> {
    private static final Map<PersistenceCompatibilityTest.Version, String> data = new HashMap<PersistenceCompatibilityTest.Version, String>(2);

    public RocksDBStoreCompatibilityTest() {
        super(IdentityKeyValueWrapper.instance());
    }

    protected void beforeStartCache(PersistenceCompatibilityTest.Version version) throws Exception {
        String root = data.get(version);
        this.copyFiles(root, "data");
        this.copyFiles(root, "expired");
    }

    public void testReadWriteFrom101() throws Exception {
        this.doTestReadWriteFrom101();
    }

    private void copyFiles(String root, String qualifier) throws IOException {
        File[] files;
        Path destLocation = this.getStoreLocation(this.combinePath(this.tmpDirectory, qualifier), qualifier);
        Files.createDirectories(destLocation, new FileAttribute[0]);
        String resource = root + "/" + qualifier;
        for (File f : files = new File(Thread.currentThread().getContextClassLoader().getResource(resource).getPath()).listFiles()) {
            String filename;
            String destFile = filename = f.getName();
            if (filename.endsWith("_log")) {
                destFile = filename.replace("_log", ".log");
            }
            RocksDBStoreCompatibilityTest.copyFile((String)this.combinePath(resource, filename), (Path)destLocation, (String)destFile);
        }
    }

    protected String cacheName() {
        return "rocksdb-cache-store";
    }

    protected void configurePersistence(ConfigurationBuilder builder) {
        ((RocksDBStoreConfigurationBuilder)((RocksDBStoreConfigurationBuilder)builder.persistence().addStore(RocksDBStoreConfigurationBuilder.class)).segmented(false)).location(this.combinePath(this.tmpDirectory, "data")).expiredLocation(this.combinePath(this.tmpDirectory, "expired"));
    }

    static {
        data.put(PersistenceCompatibilityTest.Version._10_1, "10_1_x_rocksdb_data");
        data.put(PersistenceCompatibilityTest.Version._11_0, "11_0_x_rocksdb_data");
    }
}

