/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb;

import java.io.File;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.persistence.BaseStoreFunctionalTest;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.rocksdb.RocksDBException;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.rocksdb.RocksDBStoreFunctionalTest")
public class RocksDBStoreFunctionalTest
extends BaseStoreFunctionalTest {
    protected String tmpDirectory = CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass());

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    RocksDBStoreConfigurationBuilder createStoreBuilder(PersistenceConfigurationBuilder loaders) {
        new File(this.tmpDirectory).mkdirs();
        return ((RocksDBStoreConfigurationBuilder)loaders.addStore(RocksDBStoreConfigurationBuilder.class)).location(this.tmpDirectory + "/data").expiredLocation(this.tmpDirectory + "/expiry").clearThreshold(2);
    }

    protected PersistenceConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder persistence, String cacheName, boolean preload) {
        this.createStoreBuilder(persistence).preload(preload);
        return persistence;
    }

    public void testUnknownProperties() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.read(this.cacheManager.getDefaultCacheConfiguration());
        new File(this.tmpDirectory).mkdirs();
        RocksDBStoreConfigurationBuilder storeConfigurationBuilder = this.createStoreBuilder(cb.persistence());
        storeConfigurationBuilder.addProperty("database.unknown", "some_value");
        Configuration c = cb.build();
        String cacheName = "rocksdb-unknown-properties";
        this.cacheManager.defineConfiguration(cacheName, c);
        try {
            this.cacheManager.getCache(cacheName);
        }
        catch (Throwable t) {
            Throwable cause;
            while ((cause = t.getCause()) != null) {
                t = cause;
            }
            Exceptions.assertException(CacheConfigurationException.class, (String)".*unknown\\ property$", (Throwable)t);
        }
        this.cacheManager.stop();
    }

    public void testKnownProperties() throws RocksDBException {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.read(this.cacheManager.getDefaultCacheConfiguration());
        new File(this.tmpDirectory).mkdirs();
        RocksDBStoreConfigurationBuilder storeConfigurationBuilder = this.createStoreBuilder(cb.persistence());
        String dbOptionName = "max_background_compactions";
        String dbOptionValue = "2";
        storeConfigurationBuilder.addProperty("database." + dbOptionName, dbOptionValue);
        String columnFamilyOptionName = "write_buffer_size";
        String columnFamilyOptionValue = "96MB";
        storeConfigurationBuilder.addProperty("data." + columnFamilyOptionName, columnFamilyOptionValue);
        Configuration c = cb.build();
        String cacheName = "rocksdb-known-properties";
        this.cacheManager.defineConfiguration(cacheName, c);
        AssertJUnit.assertNotNull((Object)this.cacheManager.getCache(cacheName));
    }
}

