/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.AbstractPersistenceCompatibilityTest;
import org.infinispan.persistence.IdentityKeyValueWrapper;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.test.data.Value;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.rocksdb.RocksDBStoreCompatibilityTest")
public class RocksDBStoreCompatibilityTest
extends AbstractPersistenceCompatibilityTest<Value> {
    private static final Map<AbstractPersistenceCompatibilityTest.Version, String> data = new HashMap<AbstractPersistenceCompatibilityTest.Version, String>(2);

    public RocksDBStoreCompatibilityTest() {
        super(IdentityKeyValueWrapper.instance());
    }

    @Test
    public void testReadWriteFrom101() throws Exception {
        this.setParameters(AbstractPersistenceCompatibilityTest.Version._10_1, false, false);
        this.doTestReadWrite();
    }

    @Test
    public void testReadWriteFrom11() throws Exception {
        this.setParameters(AbstractPersistenceCompatibilityTest.Version._11_0, false, false);
        this.doTestReadWrite();
    }

    protected void beforeStartCache() throws Exception {
        String root = data.get(this.oldVersion);
        this.copyFiles(root, "data");
        this.copyFiles(root, "expired");
    }

    private void copyFiles(String root, String qualifier) throws IOException {
        File[] files;
        Path destLocation = this.getStoreLocation(this.combinePath(this.tmpDirectory, qualifier), qualifier);
        Files.createDirectories(destLocation, new FileAttribute[0]);
        String resource = root + "/" + qualifier;
        for (File f : files = new File(Thread.currentThread().getContextClassLoader().getResource(resource).getPath()).listFiles()) {
            String filename;
            String destFile = filename = f.getName();
            if (filename.endsWith("_log")) {
                destFile = filename.replace("_log", ".log");
            }
            RocksDBStoreCompatibilityTest.copyFile((String)this.combinePath(resource, filename), (Path)destLocation, (String)destFile);
        }
    }

    protected String cacheName() {
        return "rocksdb-cache-store";
    }

    protected void configurePersistence(ConfigurationBuilder builder, boolean generatingData) {
        ((RocksDBStoreConfigurationBuilder)((RocksDBStoreConfigurationBuilder)builder.persistence().addStore(RocksDBStoreConfigurationBuilder.class)).segmented(this.oldSegmented)).location(this.combinePath(this.tmpDirectory, "data")).expiredLocation(this.combinePath(this.tmpDirectory, "expired"));
    }

    static {
        data.put(AbstractPersistenceCompatibilityTest.Version._10_1, "10_1_x_rocksdb_data");
        data.put(AbstractPersistenceCompatibilityTest.Version._11_0, "11_0_x_rocksdb_data");
    }
}

