/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.rocksdb.RocksDBStore;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.rocksdb.RocksDBStoreTest")
public class RocksDBStoreTest
extends BaseStoreTest {
    private String tmpDirectory = TestingUtil.tmpDirectory(((Object)((Object)this)).getClass());

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    protected RocksDBStoreConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder lcb) {
        RocksDBStoreConfigurationBuilder cfg = (RocksDBStoreConfigurationBuilder)lcb.addStore(RocksDBStoreConfigurationBuilder.class);
        cfg.location(this.tmpDirectory + "/data");
        cfg.expiredLocation(this.tmpDirectory + "/expiry");
        cfg.clearThreshold(2);
        return cfg;
    }

    protected AdvancedLoadWriteStore createStore() throws Exception {
        this.clearTempDir();
        RocksDBStore fcs = new RocksDBStore();
        ConfigurationBuilder cb = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        this.createCacheStoreConfig(cb.persistence());
        fcs.init(this.createContext(cb.build()));
        return fcs;
    }

    @Test(groups={"stress"}, timeOut=900000L)
    public void testConcurrentWriteAndRestart() {
        this.concurrentWriteAndRestart(true);
    }

    @Test(groups={"stress"}, timeOut=900000L)
    public void testConcurrentWriteAndStop() {
        this.concurrentWriteAndRestart(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concurrentWriteAndRestart(boolean start) {
        int THREADS = 4;
        final AtomicBoolean run = new AtomicBoolean(true);
        final AtomicInteger writtenPre = new AtomicInteger();
        final AtomicInteger writtenPost = new AtomicInteger();
        final AtomicBoolean post = new AtomicBoolean(false);
        final CountDownLatch started = new CountDownLatch(4);
        final CountDownLatch finished = new CountDownLatch(4);
        int i = 0;
        while (i < 4) {
            final int thread = i++;
            this.fork(new Runnable(){

                @Override
                public void run() {
                    try {
                        started.countDown();
                        int i = 0;
                        while (run.get()) {
                            InternalCacheEntry entry = TestInternalCacheEntryFactory.create((Object)("k" + i), (Object)("v" + i));
                            MarshalledEntry me = TestingUtil.marshalledEntry((InternalCacheEntry)entry, (StreamingMarshaller)RocksDBStoreTest.this.getMarshaller());
                            try {
                                int prev;
                                AtomicInteger record = post.get() ? writtenPost : writtenPre;
                                RocksDBStoreTest.this.cl.write(me);
                                ++i;
                                while (((prev = record.get()) & 1 << thread) == 0) {
                                    if (record.compareAndSet(prev, prev | 1 << thread)) continue;
                                }
                            }
                            catch (PersistenceException persistenceException) {}
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    finally {
                        finished.countDown();
                    }
                }
            });
        }
        try {
            if (!started.await(30L, TimeUnit.SECONDS)) {
                Assert.fail();
            }
            Thread.sleep(1000L);
            this.cl.stop();
            post.set(true);
            Thread.sleep(1000L);
            if (start) {
                this.cl.start();
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        finally {
            run.set(false);
        }
        try {
            if (!finished.await(30L, TimeUnit.SECONDS)) {
                Assert.fail();
            }
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        Assert.assertEquals((int)writtenPre.get(), (int)15, (String)"pre");
        if (start) {
            Assert.assertEquals((int)writtenPost.get(), (int)15, (String)"post");
        } else {
            Assert.assertEquals((int)writtenPost.get(), (int)0, (String)"post");
        }
    }
}

