/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.s3.jclouds;

import com.google.common.base.Preconditions;
import com.google.inject.Module;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.loaders.s3.S3CacheStoreConfig;
import org.infinispan.loaders.s3.S3Connection;
import org.infinispan.loaders.s3.S3ConnectionException;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.logging.LogFactory;
import org.jclouds.aws.s3.S3Context;
import org.jclouds.aws.s3.S3ContextFactory;
import org.jclouds.aws.s3.domain.S3Bucket;
import org.jclouds.http.httpnio.config.HttpNioConnectionPoolClientModule;
import org.jclouds.logging.jdk.config.JDKLoggingModule;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCloudsConnection
implements S3Connection<org.jclouds.aws.s3.S3Connection, S3Bucket> {
    protected org.jclouds.aws.s3.S3Connection s3Service;
    protected S3Context context;
    protected Marshaller marshaller;
    protected S3CacheStoreConfig config;

    @Override
    public void connect(S3CacheStoreConfig config, Marshaller m) throws S3ConnectionException {
        this.config = config;
        try {
            InputStream propertiesIS = JCloudsConnection.class.getResourceAsStream("/jclouds.properties");
            Properties properties = new Properties();
            properties.load(propertiesIS);
            if (!config.isSecure()) {
                properties.setProperty("jclouds.http.port", "80");
                properties.setProperty("jclouds.http.secure", "false");
            }
            if (properties.containsKey("jclouds.s3.map.timeout")) {
                config.setRequestTimeout(Long.parseLong(properties.getProperty("jclouds.s3.map.timeout")));
            } else {
                properties.setProperty("jclouds.s3.map.timeout", config.getRequestTimeout() + "");
            }
            if (!properties.containsKey("jclouds.aws.accesskeyid")) {
                properties.setProperty("jclouds.aws.accesskeyid", (String)Preconditions.checkNotNull((Object)config.getAwsAccessKey(), (Object)"config.getAwsAccessKey()"));
            }
            if (!properties.containsKey("jclouds.aws.secretaccesskey")) {
                properties.setProperty("jclouds.aws.secretaccesskey", (String)Preconditions.checkNotNull((Object)config.getAwsSecretKey(), (Object)"config.getAwsSecretKey()"));
            }
            if (!properties.containsKey("jclouds.pool.max_connections")) {
                properties.setProperty("jclouds.pool.max_connections", config.getMaxConnections() + "");
            }
            Log4JLoggingModule loggingModule = LogFactory.IS_LOG4J_AVAILABLE ? new Log4JLoggingModule() : new JDKLoggingModule();
            this.context = S3ContextFactory.createS3Context((Properties)properties, (Module[])new Module[]{new HttpNioConnectionPoolClientModule(), loggingModule});
            this.s3Service = this.context.getConnection();
            if (this.s3Service == null) {
                throw new S3ConnectionException("Could not connect");
            }
        }
        catch (Exception ex) {
            throw this.convertToS3ConnectionException("Exception connecting to s3", ex);
        }
        this.marshaller = m;
    }

    @Override
    public org.jclouds.aws.s3.S3Connection getConnection() throws S3ConnectionException {
        return this.s3Service;
    }

    @Override
    public S3Bucket verifyOrCreateBucket(String bucketName) throws S3ConnectionException {
        try {
            S3Bucket bucket = new S3Bucket(bucketName);
            this.s3Service.putBucketIfNotExists(bucketName).get(this.config.getRequestTimeout(), TimeUnit.MILLISECONDS);
            return bucket;
        }
        catch (Exception ex) {
            throw this.convertToS3ConnectionException("Exception retrieving or creating s3 bucket " + bucketName, ex);
        }
    }

    @Override
    public void destroyBucket(String name) throws S3ConnectionException {
        try {
            this.context.createS3ObjectMap(name).clear();
            this.s3Service.deleteBucketIfEmpty(name);
        }
        catch (Exception ex) {
            throw this.convertToS3ConnectionException("Exception removing s3 bucket " + name, ex);
        }
    }

    Set<String> keysInBucket(S3Bucket bucket) throws S3ConnectionException {
        return this.context.createS3ObjectMap(bucket.getName()).keySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void copyBucket(String sourceBucket, String destinationBucket) throws S3ConnectionException {
        try {
            S3Bucket source = new S3Bucket(sourceBucket);
            source = (S3Bucket)this.s3Service.listBucket(sourceBucket).get(this.config.getRequestTimeout(), TimeUnit.MILLISECONDS);
            Set<String> sourceKeys = this.keysInBucket(source);
            for (String key : sourceKeys) {
                try {
                    this.s3Service.copyObject(sourceBucket, key, destinationBucket, key).get(this.config.getRequestTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (Exception ex) {
                    throw this.convertToS3ConnectionException("Exception while copying key " + key + " from bucket " + sourceBucket, ex);
                    return;
                }
            }
        }
        catch (Exception ex) {
            throw this.convertToS3ConnectionException("Cannot access bucket " + sourceBucket, ex);
        }
    }

    @Override
    public void disconnect() {
        this.context.close();
    }

    S3ConnectionException convertToS3ConnectionException(String message, Exception caught) {
        return caught instanceof S3ConnectionException ? (S3ConnectionException)((Object)caught) : new S3ConnectionException(message, caught);
    }
}

