/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.s3;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.loaders.s3.S3CacheStoreConfig;
import org.infinispan.loaders.s3.S3Connection;
import org.infinispan.loaders.s3.S3ConnectionException;
import org.infinispan.marshall.Marshaller;

public class MockS3Connection
implements S3Connection<MockS3Connection, Map<String, Bucket>> {
    private static Map<String, Map<String, Bucket>> bucketToContents = new ConcurrentHashMap<String, Map<String, Bucket>>();

    public void connect(S3CacheStoreConfig config, Marshaller m) throws S3ConnectionException {
    }

    public MockS3Connection getConnection() throws S3ConnectionException {
        return this;
    }

    public Map<String, Bucket> verifyOrCreateBucket(String bucketName) throws S3ConnectionException {
        if (!bucketToContents.containsKey(bucketName)) {
            bucketToContents.put(bucketName, new ConcurrentHashMap());
        }
        return bucketToContents.get(bucketName);
    }

    public void destroyBucket(String name) throws S3ConnectionException {
        bucketToContents.remove(name);
    }

    public void disconnect() {
    }

    public void copyBucket(String sourceBucket, String destinationBucket) throws S3ConnectionException {
        Map<String, Bucket> source = bucketToContents.get(sourceBucket);
        Map<String, Bucket> dest = bucketToContents.get(destinationBucket);
        for (Bucket bucket : source.values()) {
            dest.put(bucket.getBucketName(), bucket);
        }
    }
}

