/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.s3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.CacheDelegate;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.io.UnclosableObjectInputStream;
import org.infinispan.io.UnclosableObjectOutputStream;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.s3.MockS3Bucket;
import org.infinispan.loaders.s3.MockS3Connection;
import org.infinispan.loaders.s3.S3Bucket;
import org.infinispan.loaders.s3.S3CacheStore;
import org.infinispan.loaders.s3.S3CacheStoreConfig;
import org.infinispan.loaders.s3.S3Connection;
import org.infinispan.loaders.s3.jclouds.JCloudsBucket;
import org.infinispan.loaders.s3.jclouds.JCloudsConnection;
import org.infinispan.marshall.Marshaller;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true, testName="loaders.s3.S3CacheStoreIntegrationTest")
public class S3CacheStoreIntegrationTest
extends BaseCacheStoreTest {
    private String proxyHost;
    private int proxyPort = -1;
    private int maxConnections = 20;
    private boolean isSecure = false;
    private Class<? extends S3Connection> connectionClass;
    private Class<? extends S3Bucket> bucketClass;
    private String csBucket;
    private String cs2Bucket;
    private String accessKey;
    private String secretKey;
    private static final String sysAWSAccessKeyId = System.getProperty("jclouds.aws.accesskeyid");
    private static final String sysAWSSecretAccessKey = System.getProperty("jclouds.aws.secretaccesskey");
    protected CacheStore cs2;

    @BeforeTest
    @Parameters(value={"jclouds.aws.accesskeyid", "jclouds.aws.secretaccesskey"})
    protected void setUpClient(@Optional String AWSAccessKeyId, @Optional String AWSSecretAccessKey) throws Exception {
        this.accessKey = AWSAccessKeyId == null ? sysAWSAccessKeyId : AWSAccessKeyId;
        String string = this.secretKey = AWSSecretAccessKey == null ? sysAWSSecretAccessKey : AWSSecretAccessKey;
        if (this.accessKey == null || this.accessKey.trim().equals("") || this.secretKey == null || this.secretKey.trim().equals("")) {
            this.accessKey = "dummy";
            this.secretKey = "dummy";
            this.connectionClass = MockS3Connection.class;
            this.bucketClass = MockS3Bucket.class;
        } else {
            this.connectionClass = JCloudsConnection.class;
            this.bucketClass = JCloudsBucket.class;
            this.proxyHost = "localhost";
            this.proxyPort = 8888;
        }
        this.csBucket = (System.getProperty("user.name") + "." + ((Object)((Object)this)).getClass().getSimpleName()).toLowerCase();
        System.out.printf("accessKey: %1$s, connectionClass: %2$s, bucketClass: %3$s, bucket: %4$s%n", this.accessKey, this.connectionClass, this.bucketClass, this.csBucket);
        this.cs2Bucket = this.csBucket + "2";
    }

    protected CacheStore createCacheStore() throws Exception {
        return this.createAndStartCacheStore(this.csBucket);
    }

    protected CacheStore createAnotherCacheStore() throws Exception {
        return this.createAndStartCacheStore(this.cs2Bucket);
    }

    private CacheStore createAndStartCacheStore(String bucket) throws Exception {
        S3CacheStore cs = new S3CacheStore();
        S3CacheStoreConfig cfg = new S3CacheStoreConfig();
        cfg.setBucketPrefix(bucket);
        cfg.setAwsAccessKey(this.accessKey);
        cfg.setAwsSecretKey(this.secretKey);
        cfg.setProxyHost(this.proxyHost);
        cfg.setProxyPort(this.proxyPort);
        cfg.setSecure(this.isSecure);
        cfg.setMaxConnections(this.maxConnections);
        cfg.setPurgeSynchronously(Boolean.valueOf(true));
        cs.init((CacheLoaderConfig)cfg, (Cache)new CacheDelegate("aName"), this.getMarshaller(), this.connectionClass.newInstance(), this.bucketClass.newInstance());
        cs.start();
        return cs;
    }

    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
        this.cs.clear();
        Set entries = this.cs.loadAll();
        assert (entries.size() == 0);
        this.cs2 = this.createAnotherCacheStore();
        this.cs2.clear();
        entries = this.cs2.loadAll();
        assert (entries.size() == 0);
    }

    @AfterMethod
    public void tearDown() throws CacheLoaderException {
        if (this.cs != null) {
            this.cs.clear();
            this.cs.stop();
        }
        this.cs = null;
        if (this.cs2 != null) {
            this.cs2.clear();
            this.cs2.stop();
        }
        this.cs2 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStreamingAPI() throws IOException, ClassNotFoundException, CacheLoaderException {
        this.cs.store(InternalEntryFactory.create((Object)"k1", (Object)"v1", (long)-1L, (long)-1L));
        this.cs.store(InternalEntryFactory.create((Object)"k2", (Object)"v2", (long)-1L, (long)-1L));
        this.cs.store(InternalEntryFactory.create((Object)"k3", (Object)"v3", (long)-1L, (long)-1L));
        Marshaller marshaller = this.getMarshaller();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutput oo = marshaller.startObjectOutput((OutputStream)out, false);
        try {
            this.cs.toStream((ObjectOutput)new UnclosableObjectOutputStream(oo));
        }
        finally {
            marshaller.finishObjectOutput(oo);
            out.close();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ObjectInput oi = marshaller.startObjectInput((InputStream)in, false);
        try {
            this.cs2.fromStream((ObjectInput)new UnclosableObjectInputStream(oi));
        }
        finally {
            marshaller.finishObjectInput(oi);
            in.close();
        }
        Set set = this.cs2.loadAll();
        Assert.assertEquals((int)set.size(), (int)3);
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        for (InternalCacheEntry se : set) {
            assert (expected.remove(se.getKey()));
        }
        assert (expected.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStreamingAPIReusingStreams() throws IOException, ClassNotFoundException, CacheLoaderException {
        this.cs.store(InternalEntryFactory.create((Object)"k1", (Object)"v1", (long)-1L, (long)-1L));
        this.cs.store(InternalEntryFactory.create((Object)"k2", (Object)"v2", (long)-1L, (long)-1L));
        this.cs.store(InternalEntryFactory.create((Object)"k3", (Object)"v3", (long)-1L, (long)-1L));
        Marshaller marshaller = this.getMarshaller();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] dummyStartBytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] dummyEndBytes = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        ObjectOutput oo = marshaller.startObjectOutput((OutputStream)out, false);
        try {
            oo.write(dummyStartBytes);
            this.cs.toStream((ObjectOutput)new UnclosableObjectOutputStream(oo));
            oo.flush();
            oo.write(dummyEndBytes);
        }
        finally {
            marshaller.finishObjectOutput(oo);
            out.close();
        }
        byte[] dummy = new byte[8];
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ObjectInput oi = marshaller.startObjectInput((InputStream)in, false);
        try {
            byte i;
            int bytesRead = oi.read(dummy, 0, 8);
            assert (bytesRead == 8);
            for (i = 1; i < 9; ++i) {
                assert (dummy[i - 1] == i) : "Start byte stream corrupted!";
            }
            this.cs2.fromStream((ObjectInput)new UnclosableObjectInputStream(oi));
            bytesRead = oi.read(dummy, 0, 8);
            assert (bytesRead == 8);
            for (i = 8; i > 0; --i) {
                assert (dummy[8 - i] == i) : "Start byte stream corrupted!";
            }
        }
        finally {
            marshaller.finishObjectInput(oi);
            in.close();
        }
        Set set = this.cs2.loadAll();
        Assert.assertEquals((int)set.size(), (int)3);
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        for (InternalCacheEntry se : set) {
            assert (expected.remove(se.getKey()));
        }
        assert (expected.isEmpty());
    }
}

