/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.s3;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.loaders.s3.MockS3Connection;
import org.infinispan.loaders.s3.S3Bucket;
import org.infinispan.loaders.s3.S3ConnectionException;
import org.infinispan.marshall.Marshaller;

public class MockS3Bucket
implements S3Bucket<Map<String, Bucket>, MockS3Connection> {
    private String name;
    private Map<String, Bucket> s3Bucket;

    public void init(String name, String awsAccessKey, String awsSecretKey, Marshaller m) throws S3ConnectionException {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Set<Bucket> values() throws S3ConnectionException {
        return new HashSet<Bucket>(this.s3Bucket.values());
    }

    public void init(MockS3Connection connection, Map<String, Bucket> bucket) {
        this.s3Bucket = bucket;
    }

    public void insert(Bucket object) throws S3ConnectionException {
        this.s3Bucket.put(object.getBucketName(), object);
    }

    public Bucket get(String key) throws S3ConnectionException {
        return this.s3Bucket.get(key);
    }

    public Set<String> keySet() throws S3ConnectionException {
        return this.s3Bucket.keySet();
    }

    public void remove(String key) throws S3ConnectionException {
        this.s3Bucket.remove(key);
    }

    public void clear() throws S3ConnectionException {
        this.s3Bucket.clear();
    }
}

